package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetInstanceTrendingReport invokes the ccc.GetInstanceTrendingReport API synchronously
func (client *Client) GetInstanceTrendingReport(request *GetInstanceTrendingReportRequest) (response *GetInstanceTrendingReportResponse, err error) {
	response = CreateGetInstanceTrendingReportResponse()
	err = client.DoAction(request, response)
	return
}

// GetInstanceTrendingReportWithChan invokes the ccc.GetInstanceTrendingReport API asynchronously
func (client *Client) GetInstanceTrendingReportWithChan(request *GetInstanceTrendingReportRequest) (<-chan *GetInstanceTrendingReportResponse, <-chan error) {
	responseChan := make(chan *GetInstanceTrendingReportResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetInstanceTrendingReport(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetInstanceTrendingReportWithCallback invokes the ccc.GetInstanceTrendingReport API asynchronously
func (client *Client) GetInstanceTrendingReportWithCallback(request *GetInstanceTrendingReportRequest, callback func(response *GetInstanceTrendingReportResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetInstanceTrendingReportResponse
		var err error
		defer close(result)
		response, err = client.GetInstanceTrendingReport(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetInstanceTrendingReportRequest is the request struct for api GetInstanceTrendingReport
type GetInstanceTrendingReportRequest struct {
	*requests.RpcRequest
	EndTime    requests.Integer `position:"Query" name:"EndTime"`
	StartTime  requests.Integer `position:"Query" name:"StartTime"`
	InstanceId string           `position:"Query" name:"InstanceId"`
}

// GetInstanceTrendingReportResponse is the response struct for api GetInstanceTrendingReport
type GetInstanceTrendingReportResponse struct {
	*responses.BaseResponse
	Code           string                          `json:"Code" xml:"Code"`
	HttpStatusCode int                             `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string                          `json:"Message" xml:"Message"`
	RequestId      string                          `json:"RequestId" xml:"RequestId"`
	Data           DataInGetInstanceTrendingReport `json:"Data" xml:"Data"`
}

// CreateGetInstanceTrendingReportRequest creates a request to invoke GetInstanceTrendingReport API
func CreateGetInstanceTrendingReportRequest() (request *GetInstanceTrendingReportRequest) {
	request = &GetInstanceTrendingReportRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "GetInstanceTrendingReport", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetInstanceTrendingReportResponse creates a response to parse from GetInstanceTrendingReport response
func CreateGetInstanceTrendingReportResponse() (response *GetInstanceTrendingReportResponse) {
	response = &GetInstanceTrendingReportResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
