package cloudauth

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateFaceConfig invokes the cloudauth.CreateFaceConfig API synchronously
func (client *Client) CreateFaceConfig(request *CreateFaceConfigRequest) (response *CreateFaceConfigResponse, err error) {
	response = CreateCreateFaceConfigResponse()
	err = client.DoAction(request, response)
	return
}

// CreateFaceConfigWithChan invokes the cloudauth.CreateFaceConfig API asynchronously
func (client *Client) CreateFaceConfigWithChan(request *CreateFaceConfigRequest) (<-chan *CreateFaceConfigResponse, <-chan error) {
	responseChan := make(chan *CreateFaceConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateFaceConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateFaceConfigWithCallback invokes the cloudauth.CreateFaceConfig API asynchronously
func (client *Client) CreateFaceConfigWithCallback(request *CreateFaceConfigRequest, callback func(response *CreateFaceConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateFaceConfigResponse
		var err error
		defer close(result)
		response, err = client.CreateFaceConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateFaceConfigRequest is the request struct for api CreateFaceConfig
type CreateFaceConfigRequest struct {
	*requests.RpcRequest
	BizName  string `position:"Query" name:"BizName"`
	BizType  string `position:"Query" name:"BizType"`
	SourceIp string `position:"Query" name:"SourceIp"`
	Lang     string `position:"Query" name:"Lang"`
}

// CreateFaceConfigResponse is the response struct for api CreateFaceConfig
type CreateFaceConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateFaceConfigRequest creates a request to invoke CreateFaceConfig API
func CreateCreateFaceConfigRequest() (request *CreateFaceConfigRequest) {
	request = &CreateFaceConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudauth", "2019-03-07", "CreateFaceConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateFaceConfigResponse creates a response to parse from CreateFaceConfig response
func CreateCreateFaceConfigResponse() (response *CreateFaceConfigResponse) {
	response = &CreateFaceConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
