package cloudauth

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeWhitelistSetting invokes the cloudauth.DescribeWhitelistSetting API synchronously
func (client *Client) DescribeWhitelistSetting(request *DescribeWhitelistSettingRequest) (response *DescribeWhitelistSettingResponse, err error) {
	response = CreateDescribeWhitelistSettingResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeWhitelistSettingWithChan invokes the cloudauth.DescribeWhitelistSetting API asynchronously
func (client *Client) DescribeWhitelistSettingWithChan(request *DescribeWhitelistSettingRequest) (<-chan *DescribeWhitelistSettingResponse, <-chan error) {
	responseChan := make(chan *DescribeWhitelistSettingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeWhitelistSetting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeWhitelistSettingWithCallback invokes the cloudauth.DescribeWhitelistSetting API asynchronously
func (client *Client) DescribeWhitelistSettingWithCallback(request *DescribeWhitelistSettingRequest, callback func(response *DescribeWhitelistSettingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeWhitelistSettingResponse
		var err error
		defer close(result)
		response, err = client.DescribeWhitelistSetting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeWhitelistSettingRequest is the request struct for api DescribeWhitelistSetting
type DescribeWhitelistSettingRequest struct {
	*requests.RpcRequest
	ValidEndDate   requests.Integer `position:"Query" name:"ValidEndDate"`
	CertifyId      string           `position:"Query" name:"CertifyId"`
	CertNo         string           `position:"Query" name:"CertNo"`
	SourceIp       string           `position:"Query" name:"SourceIp"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	Lang           string           `position:"Query" name:"Lang"`
	CurrentPage    requests.Integer `position:"Query" name:"CurrentPage"`
	ServiceCode    string           `position:"Query" name:"ServiceCode"`
	SceneId        requests.Integer `position:"Query" name:"SceneId"`
	ValidStartDate requests.Integer `position:"Query" name:"ValidStartDate"`
	Status         string           `position:"Query" name:"Status"`
}

// DescribeWhitelistSettingResponse is the response struct for api DescribeWhitelistSetting
type DescribeWhitelistSettingResponse struct {
	*responses.BaseResponse
	RequestId   string                           `json:"RequestId" xml:"RequestId"`
	TotalCount  int                              `json:"TotalCount" xml:"TotalCount"`
	CurrentPage int                              `json:"CurrentPage" xml:"CurrentPage"`
	PageSize    int                              `json:"PageSize" xml:"PageSize"`
	Items       []ItemInDescribeWhitelistSetting `json:"Items" xml:"Items"`
}

// CreateDescribeWhitelistSettingRequest creates a request to invoke DescribeWhitelistSetting API
func CreateDescribeWhitelistSettingRequest() (request *DescribeWhitelistSettingRequest) {
	request = &DescribeWhitelistSettingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudauth", "2019-03-07", "DescribeWhitelistSetting", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeWhitelistSettingResponse creates a response to parse from DescribeWhitelistSetting response
func CreateDescribeWhitelistSettingResponse() (response *DescribeWhitelistSettingResponse) {
	response = &DescribeWhitelistSettingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
