package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StandardTemplateDemo invokes the cloudcallcenter.StandardTemplateDemo API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/standardtemplatedemo.html
func (client *Client) StandardTemplateDemo(request *StandardTemplateDemoRequest) (response *StandardTemplateDemoResponse, err error) {
	response = CreateStandardTemplateDemoResponse()
	err = client.DoAction(request, response)
	return
}

// StandardTemplateDemoWithChan invokes the cloudcallcenter.StandardTemplateDemo API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/standardtemplatedemo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) StandardTemplateDemoWithChan(request *StandardTemplateDemoRequest) (<-chan *StandardTemplateDemoResponse, <-chan error) {
	responseChan := make(chan *StandardTemplateDemoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StandardTemplateDemo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StandardTemplateDemoWithCallback invokes the cloudcallcenter.StandardTemplateDemo API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/standardtemplatedemo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) StandardTemplateDemoWithCallback(request *StandardTemplateDemoRequest, callback func(response *StandardTemplateDemoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StandardTemplateDemoResponse
		var err error
		defer close(result)
		response, err = client.StandardTemplateDemo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StandardTemplateDemoRequest is the request struct for api StandardTemplateDemo
type StandardTemplateDemoRequest struct {
	*requests.RpcRequest
	PhoneNumber string `position:"Query" name:"PhoneNumber"`
	ScenarioId  string `position:"Query" name:"ScenarioId"`
}

// StandardTemplateDemoResponse is the response struct for api StandardTemplateDemo
type StandardTemplateDemoResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateStandardTemplateDemoRequest creates a request to invoke StandardTemplateDemo API
func CreateStandardTemplateDemoRequest() (request *StandardTemplateDemoRequest) {
	request = &StandardTemplateDemoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "StandardTemplateDemo", "", "")
	request.Method = requests.POST
	return
}

// CreateStandardTemplateDemoResponse creates a response to parse from StandardTemplateDemo response
func CreateStandardTemplateDemoResponse() (response *StandardTemplateDemoResponse) {
	response = &StandardTemplateDemoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
