package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// Upload400CorpIdentifyFile invokes the cloudcallcenter.Upload400CorpIdentifyFile API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/upload400corpidentifyfile.html
func (client *Client) Upload400CorpIdentifyFile(request *Upload400CorpIdentifyFileRequest) (response *Upload400CorpIdentifyFileResponse, err error) {
	response = CreateUpload400CorpIdentifyFileResponse()
	err = client.DoAction(request, response)
	return
}

// Upload400CorpIdentifyFileWithChan invokes the cloudcallcenter.Upload400CorpIdentifyFile API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/upload400corpidentifyfile.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) Upload400CorpIdentifyFileWithChan(request *Upload400CorpIdentifyFileRequest) (<-chan *Upload400CorpIdentifyFileResponse, <-chan error) {
	responseChan := make(chan *Upload400CorpIdentifyFileResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.Upload400CorpIdentifyFile(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// Upload400CorpIdentifyFileWithCallback invokes the cloudcallcenter.Upload400CorpIdentifyFile API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/upload400corpidentifyfile.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) Upload400CorpIdentifyFileWithCallback(request *Upload400CorpIdentifyFileRequest, callback func(response *Upload400CorpIdentifyFileResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *Upload400CorpIdentifyFileResponse
		var err error
		defer close(result)
		response, err = client.Upload400CorpIdentifyFile(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// Upload400CorpIdentifyFileRequest is the request struct for api Upload400CorpIdentifyFile
type Upload400CorpIdentifyFileRequest struct {
	*requests.RpcRequest
	CccKey string `position:"Query" name:"CccKey"`
}

// Upload400CorpIdentifyFileResponse is the response struct for api Upload400CorpIdentifyFile
type Upload400CorpIdentifyFileResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateUpload400CorpIdentifyFileRequest creates a request to invoke Upload400CorpIdentifyFile API
func CreateUpload400CorpIdentifyFileRequest() (request *Upload400CorpIdentifyFileRequest) {
	request = &Upload400CorpIdentifyFileRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "Upload400CorpIdentifyFile", "", "")
	request.Method = requests.POST
	return
}

// CreateUpload400CorpIdentifyFileResponse creates a response to parse from Upload400CorpIdentifyFile response
func CreateUpload400CorpIdentifyFileResponse() (response *Upload400CorpIdentifyFileResponse) {
	response = &Upload400CorpIdentifyFileResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
