package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetLastMonthInvoiceCount invokes the companyreg.GetLastMonthInvoiceCount API synchronously
func (client *Client) GetLastMonthInvoiceCount(request *GetLastMonthInvoiceCountRequest) (response *GetLastMonthInvoiceCountResponse, err error) {
	response = CreateGetLastMonthInvoiceCountResponse()
	err = client.DoAction(request, response)
	return
}

// GetLastMonthInvoiceCountWithChan invokes the companyreg.GetLastMonthInvoiceCount API asynchronously
func (client *Client) GetLastMonthInvoiceCountWithChan(request *GetLastMonthInvoiceCountRequest) (<-chan *GetLastMonthInvoiceCountResponse, <-chan error) {
	responseChan := make(chan *GetLastMonthInvoiceCountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetLastMonthInvoiceCount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetLastMonthInvoiceCountWithCallback invokes the companyreg.GetLastMonthInvoiceCount API asynchronously
func (client *Client) GetLastMonthInvoiceCountWithCallback(request *GetLastMonthInvoiceCountRequest, callback func(response *GetLastMonthInvoiceCountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetLastMonthInvoiceCountResponse
		var err error
		defer close(result)
		response, err = client.GetLastMonthInvoiceCount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetLastMonthInvoiceCountRequest is the request struct for api GetLastMonthInvoiceCount
type GetLastMonthInvoiceCountRequest struct {
	*requests.RpcRequest
	BizId string `position:"Query" name:"BizId"`
}

// GetLastMonthInvoiceCountResponse is the response struct for api GetLastMonthInvoiceCount
type GetLastMonthInvoiceCountResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	InvoiceIncome InvoiceIncome `json:"InvoiceIncome" xml:"InvoiceIncome"`
	InvoiceOut    InvoiceOut    `json:"InvoiceOut" xml:"InvoiceOut"`
}

// CreateGetLastMonthInvoiceCountRequest creates a request to invoke GetLastMonthInvoiceCount API
func CreateGetLastMonthInvoiceCountRequest() (request *GetLastMonthInvoiceCountRequest) {
	request = &GetLastMonthInvoiceCountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "GetLastMonthInvoiceCount", "companyreg", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetLastMonthInvoiceCountResponse creates a response to parse from GetLastMonthInvoiceCount response
func CreateGetLastMonthInvoiceCountResponse() (response *GetLastMonthInvoiceCountResponse) {
	response = &GetLastMonthInvoiceCountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
