package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetNotice invokes the companyreg.GetNotice API synchronously
func (client *Client) GetNotice(request *GetNoticeRequest) (response *GetNoticeResponse, err error) {
	response = CreateGetNoticeResponse()
	err = client.DoAction(request, response)
	return
}

// GetNoticeWithChan invokes the companyreg.GetNotice API asynchronously
func (client *Client) GetNoticeWithChan(request *GetNoticeRequest) (<-chan *GetNoticeResponse, <-chan error) {
	responseChan := make(chan *GetNoticeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetNotice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetNoticeWithCallback invokes the companyreg.GetNotice API asynchronously
func (client *Client) GetNoticeWithCallback(request *GetNoticeRequest, callback func(response *GetNoticeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetNoticeResponse
		var err error
		defer close(result)
		response, err = client.GetNotice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetNoticeRequest is the request struct for api GetNotice
type GetNoticeRequest struct {
	*requests.RpcRequest
	BizId string `position:"Query" name:"BizId"`
}

// GetNoticeResponse is the response struct for api GetNotice
type GetNoticeResponse struct {
	*responses.BaseResponse
	RequestId         string `json:"RequestId" xml:"RequestId"`
	Period            string `json:"Period" xml:"Period"`
	MessagePromptType string `json:"MessagePromptType" xml:"MessagePromptType"`
	Month             string `json:"Month" xml:"Month"`
}

// CreateGetNoticeRequest creates a request to invoke GetNotice API
func CreateGetNoticeRequest() (request *GetNoticeRequest) {
	request = &GetNoticeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "GetNotice", "companyreg", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetNoticeResponse creates a response to parse from GetNotice response
func CreateGetNoticeResponse() (response *GetNoticeResponse) {
	response = &GetNoticeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
