package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetQuarterCashFlowInfo invokes the companyreg.GetQuarterCashFlowInfo API synchronously
func (client *Client) GetQuarterCashFlowInfo(request *GetQuarterCashFlowInfoRequest) (response *GetQuarterCashFlowInfoResponse, err error) {
	response = CreateGetQuarterCashFlowInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetQuarterCashFlowInfoWithChan invokes the companyreg.GetQuarterCashFlowInfo API asynchronously
func (client *Client) GetQuarterCashFlowInfoWithChan(request *GetQuarterCashFlowInfoRequest) (<-chan *GetQuarterCashFlowInfoResponse, <-chan error) {
	responseChan := make(chan *GetQuarterCashFlowInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetQuarterCashFlowInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetQuarterCashFlowInfoWithCallback invokes the companyreg.GetQuarterCashFlowInfo API asynchronously
func (client *Client) GetQuarterCashFlowInfoWithCallback(request *GetQuarterCashFlowInfoRequest, callback func(response *GetQuarterCashFlowInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetQuarterCashFlowInfoResponse
		var err error
		defer close(result)
		response, err = client.GetQuarterCashFlowInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetQuarterCashFlowInfoRequest is the request struct for api GetQuarterCashFlowInfo
type GetQuarterCashFlowInfoRequest struct {
	*requests.RpcRequest
	Period    string           `position:"Query" name:"Period"`
	BizId     string           `position:"Query" name:"BizId"`
	IsQuarter requests.Boolean `position:"Query" name:"IsQuarter"`
}

// GetQuarterCashFlowInfoResponse is the response struct for api GetQuarterCashFlowInfo
type GetQuarterCashFlowInfoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Url       string `json:"Url" xml:"Url"`
}

// CreateGetQuarterCashFlowInfoRequest creates a request to invoke GetQuarterCashFlowInfo API
func CreateGetQuarterCashFlowInfoRequest() (request *GetQuarterCashFlowInfoRequest) {
	request = &GetQuarterCashFlowInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "GetQuarterCashFlowInfo", "companyreg", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetQuarterCashFlowInfoResponse creates a response to parse from GetQuarterCashFlowInfo response
func CreateGetQuarterCashFlowInfoResponse() (response *GetQuarterCashFlowInfoResponse) {
	response = &GetQuarterCashFlowInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
