package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateBookkeepingOrg invokes the companyreg.UpdateBookkeepingOrg API synchronously
func (client *Client) UpdateBookkeepingOrg(request *UpdateBookkeepingOrgRequest) (response *UpdateBookkeepingOrgResponse, err error) {
	response = CreateUpdateBookkeepingOrgResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateBookkeepingOrgWithChan invokes the companyreg.UpdateBookkeepingOrg API asynchronously
func (client *Client) UpdateBookkeepingOrgWithChan(request *UpdateBookkeepingOrgRequest) (<-chan *UpdateBookkeepingOrgResponse, <-chan error) {
	responseChan := make(chan *UpdateBookkeepingOrgResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateBookkeepingOrg(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateBookkeepingOrgWithCallback invokes the companyreg.UpdateBookkeepingOrg API asynchronously
func (client *Client) UpdateBookkeepingOrgWithCallback(request *UpdateBookkeepingOrgRequest, callback func(response *UpdateBookkeepingOrgResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateBookkeepingOrgResponse
		var err error
		defer close(result)
		response, err = client.UpdateBookkeepingOrg(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateBookkeepingOrgRequest is the request struct for api UpdateBookkeepingOrg
type UpdateBookkeepingOrgRequest struct {
	*requests.RpcRequest
	OrgAddress string `position:"Query" name:"OrgAddress"`
	OrgName    string `position:"Query" name:"OrgName"`
	OrgCode    string `position:"Query" name:"OrgCode"`
	OrgMobile  string `position:"Query" name:"OrgMobile"`
}

// UpdateBookkeepingOrgResponse is the response struct for api UpdateBookkeepingOrg
type UpdateBookkeepingOrgResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateBookkeepingOrgRequest creates a request to invoke UpdateBookkeepingOrg API
func CreateUpdateBookkeepingOrgRequest() (request *UpdateBookkeepingOrgRequest) {
	request = &UpdateBookkeepingOrgRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2019-05-08", "UpdateBookkeepingOrg", "companyreg", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateBookkeepingOrgResponse creates a response to parse from UpdateBookkeepingOrg response
func CreateUpdateBookkeepingOrgResponse() (response *UpdateBookkeepingOrgResponse) {
	response = &UpdateBookkeepingOrgResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
