package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEvaluationResults invokes the config.DescribeEvaluationResults API synchronously
func (client *Client) DescribeEvaluationResults(request *DescribeEvaluationResultsRequest) (response *DescribeEvaluationResultsResponse, err error) {
	response = CreateDescribeEvaluationResultsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEvaluationResultsWithChan invokes the config.DescribeEvaluationResults API asynchronously
func (client *Client) DescribeEvaluationResultsWithChan(request *DescribeEvaluationResultsRequest) (<-chan *DescribeEvaluationResultsResponse, <-chan error) {
	responseChan := make(chan *DescribeEvaluationResultsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEvaluationResults(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEvaluationResultsWithCallback invokes the config.DescribeEvaluationResults API asynchronously
func (client *Client) DescribeEvaluationResultsWithCallback(request *DescribeEvaluationResultsRequest, callback func(response *DescribeEvaluationResultsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEvaluationResultsResponse
		var err error
		defer close(result)
		response, err = client.DescribeEvaluationResults(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEvaluationResultsRequest is the request struct for api DescribeEvaluationResults
type DescribeEvaluationResultsRequest struct {
	*requests.RpcRequest
	ConfigRuleId   string           `position:"Query" name:"ConfigRuleId"`
	MultiAccount   requests.Boolean `position:"Query" name:"MultiAccount"`
	PageNumber     requests.Integer `position:"Query" name:"PageNumber"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	ComplianceType string           `position:"Query" name:"ComplianceType"`
	ResourceId     string           `position:"Query" name:"ResourceId"`
	ResourceType   string           `position:"Query" name:"ResourceType"`
	MemberId       requests.Integer `position:"Query" name:"MemberId"`
}

// DescribeEvaluationResultsResponse is the response struct for api DescribeEvaluationResults
type DescribeEvaluationResultsResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	EvaluationResults EvaluationResults `json:"EvaluationResults" xml:"EvaluationResults"`
}

// CreateDescribeEvaluationResultsRequest creates a request to invoke DescribeEvaluationResults API
func CreateDescribeEvaluationResultsRequest() (request *DescribeEvaluationResultsRequest) {
	request = &DescribeEvaluationResultsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2019-01-08", "DescribeEvaluationResults", "Config", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeEvaluationResultsResponse creates a response to parse from DescribeEvaluationResults response
func CreateDescribeEvaluationResultsResponse() (response *DescribeEvaluationResultsResponse) {
	response = &DescribeEvaluationResultsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
