package csb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// FindInstanceList invokes the csb.FindInstanceList API synchronously
// api document: https://help.aliyun.com/api/csb/findinstancelist.html
func (client *Client) FindInstanceList(request *FindInstanceListRequest) (response *FindInstanceListResponse, err error) {
	response = CreateFindInstanceListResponse()
	err = client.DoAction(request, response)
	return
}

// FindInstanceListWithChan invokes the csb.FindInstanceList API asynchronously
// api document: https://help.aliyun.com/api/csb/findinstancelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) FindInstanceListWithChan(request *FindInstanceListRequest) (<-chan *FindInstanceListResponse, <-chan error) {
	responseChan := make(chan *FindInstanceListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.FindInstanceList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// FindInstanceListWithCallback invokes the csb.FindInstanceList API asynchronously
// api document: https://help.aliyun.com/api/csb/findinstancelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) FindInstanceListWithCallback(request *FindInstanceListRequest, callback func(response *FindInstanceListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *FindInstanceListResponse
		var err error
		defer close(result)
		response, err = client.FindInstanceList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// FindInstanceListRequest is the request struct for api FindInstanceList
type FindInstanceListRequest struct {
	*requests.RpcRequest
	CsbId     requests.Integer `position:"Query" name:"CsbId"`
	PageNum   requests.Integer `position:"Query" name:"PageNum"`
	SearchTxt string           `position:"Query" name:"SearchTxt"`
	Status    requests.Integer `position:"Query" name:"Status"`
}

// FindInstanceListResponse is the response struct for api FindInstanceList
type FindInstanceListResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateFindInstanceListRequest creates a request to invoke FindInstanceList API
func CreateFindInstanceListRequest() (request *FindInstanceListRequest) {
	request = &FindInstanceListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CSB", "2017-11-18", "FindInstanceList", "", "")
	request.Method = requests.GET
	return
}

// CreateFindInstanceListResponse creates a response to parse from FindInstanceList response
func CreateFindInstanceListResponse() (response *FindInstanceListResponse) {
	response = &FindInstanceListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
