package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDataServiceApis invokes the dataworks_public.ListDataServiceApis API synchronously
func (client *Client) ListDataServiceApis(request *ListDataServiceApisRequest) (response *ListDataServiceApisResponse, err error) {
	response = CreateListDataServiceApisResponse()
	err = client.DoAction(request, response)
	return
}

// ListDataServiceApisWithChan invokes the dataworks_public.ListDataServiceApis API asynchronously
func (client *Client) ListDataServiceApisWithChan(request *ListDataServiceApisRequest) (<-chan *ListDataServiceApisResponse, <-chan error) {
	responseChan := make(chan *ListDataServiceApisResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDataServiceApis(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDataServiceApisWithCallback invokes the dataworks_public.ListDataServiceApis API asynchronously
func (client *Client) ListDataServiceApisWithCallback(request *ListDataServiceApisRequest, callback func(response *ListDataServiceApisResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDataServiceApisResponse
		var err error
		defer close(result)
		response, err = client.ListDataServiceApis(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDataServiceApisRequest is the request struct for api ListDataServiceApis
type ListDataServiceApisRequest struct {
	*requests.RpcRequest
	ApiNameKeyword string           `position:"Body" name:"ApiNameKeyword"`
	ApiPathKeyword string           `position:"Body" name:"ApiPathKeyword"`
	CreatorId      string           `position:"Body" name:"CreatorId"`
	PageNumber     requests.Integer `position:"Body" name:"PageNumber"`
	PageSize       requests.Integer `position:"Body" name:"PageSize"`
	TenantId       requests.Integer `position:"Body" name:"TenantId"`
	ProjectId      requests.Integer `position:"Body" name:"ProjectId"`
}

// ListDataServiceApisResponse is the response struct for api ListDataServiceApis
type ListDataServiceApisResponse struct {
	*responses.BaseResponse
	ErrorCode      string                    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string                    `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode int                       `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string                    `json:"RequestId" xml:"RequestId"`
	Success        bool                      `json:"Success" xml:"Success"`
	Data           DataInListDataServiceApis `json:"Data" xml:"Data"`
}

// CreateListDataServiceApisRequest creates a request to invoke ListDataServiceApis API
func CreateListDataServiceApisRequest() (request *ListDataServiceApisRequest) {
	request = &ListDataServiceApisRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ListDataServiceApis", "", "")
	request.Method = requests.POST
	return
}

// CreateListDataServiceApisResponse creates a response to parse from ListDataServiceApis response
func CreateListDataServiceApisResponse() (response *ListDataServiceApisResponse) {
	response = &ListDataServiceApisResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
