package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyWebRule invokes the ddoscoo.ModifyWebRule API synchronously
func (client *Client) ModifyWebRule(request *ModifyWebRuleRequest) (response *ModifyWebRuleResponse, err error) {
	response = CreateModifyWebRuleResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyWebRuleWithChan invokes the ddoscoo.ModifyWebRule API asynchronously
func (client *Client) ModifyWebRuleWithChan(request *ModifyWebRuleRequest) (<-chan *ModifyWebRuleResponse, <-chan error) {
	responseChan := make(chan *ModifyWebRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyWebRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyWebRuleWithCallback invokes the ddoscoo.ModifyWebRule API asynchronously
func (client *Client) ModifyWebRuleWithCallback(request *ModifyWebRuleRequest, callback func(response *ModifyWebRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyWebRuleResponse
		var err error
		defer close(result)
		response, err = client.ModifyWebRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyWebRuleRequest is the request struct for api ModifyWebRule
type ModifyWebRuleRequest struct {
	*requests.RpcRequest
	HttpsExt        string           `position:"Query" name:"HttpsExt"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	RsType          requests.Integer `position:"Query" name:"RsType"`
	RealServers     *[]string        `position:"Query" name:"RealServers"  type:"Repeated"`
	ProxyTypes      string           `position:"Query" name:"ProxyTypes"`
	InstanceIds     *[]string        `position:"Query" name:"InstanceIds"  type:"Repeated"`
	Domain          string           `position:"Query" name:"Domain"`
}

// ModifyWebRuleResponse is the response struct for api ModifyWebRule
type ModifyWebRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyWebRuleRequest creates a request to invoke ModifyWebRule API
func CreateModifyWebRuleRequest() (request *ModifyWebRuleRequest) {
	request = &ModifyWebRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "ModifyWebRule", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyWebRuleResponse creates a response to parse from ModifyWebRule response
func CreateModifyWebRuleResponse() (response *ModifyWebRuleResponse) {
	response = &ModifyWebRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
