package devops_rdc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTaskDetailBase invokes the devops_rdc.GetTaskDetailBase API synchronously
func (client *Client) GetTaskDetailBase(request *GetTaskDetailBaseRequest) (response *GetTaskDetailBaseResponse, err error) {
	response = CreateGetTaskDetailBaseResponse()
	err = client.DoAction(request, response)
	return
}

// GetTaskDetailBaseWithChan invokes the devops_rdc.GetTaskDetailBase API asynchronously
func (client *Client) GetTaskDetailBaseWithChan(request *GetTaskDetailBaseRequest) (<-chan *GetTaskDetailBaseResponse, <-chan error) {
	responseChan := make(chan *GetTaskDetailBaseResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTaskDetailBase(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTaskDetailBaseWithCallback invokes the devops_rdc.GetTaskDetailBase API asynchronously
func (client *Client) GetTaskDetailBaseWithCallback(request *GetTaskDetailBaseRequest, callback func(response *GetTaskDetailBaseResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTaskDetailBaseResponse
		var err error
		defer close(result)
		response, err = client.GetTaskDetailBase(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTaskDetailBaseRequest is the request struct for api GetTaskDetailBase
type GetTaskDetailBaseRequest struct {
	*requests.RpcRequest
	ProjectId string `position:"Body" name:"ProjectId"`
	OrgId     string `position:"Body" name:"OrgId"`
	TaskId    string `position:"Body" name:"TaskId"`
}

// GetTaskDetailBaseResponse is the response struct for api GetTaskDetailBase
type GetTaskDetailBaseResponse struct {
	*responses.BaseResponse
	Successful bool                      `json:"Successful" xml:"Successful"`
	ErrorCode  string                    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg   string                    `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId  string                    `json:"RequestId" xml:"RequestId"`
	Object     ObjectInGetTaskDetailBase `json:"Object" xml:"Object"`
}

// CreateGetTaskDetailBaseRequest creates a request to invoke GetTaskDetailBase API
func CreateGetTaskDetailBaseRequest() (request *GetTaskDetailBaseRequest) {
	request = &GetTaskDetailBaseRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("devops-rdc", "2020-03-03", "GetTaskDetailBase", "", "")
	request.Method = requests.POST
	return
}

// CreateGetTaskDetailBaseResponse creates a response to parse from GetTaskDetailBase response
func CreateGetTaskDetailBaseResponse() (response *GetTaskDetailBaseResponse) {
	response = &GetTaskDetailBaseResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
