package devops_rdc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDevopsScenarioFieldConfig invokes the devops_rdc.ListDevopsScenarioFieldConfig API synchronously
func (client *Client) ListDevopsScenarioFieldConfig(request *ListDevopsScenarioFieldConfigRequest) (response *ListDevopsScenarioFieldConfigResponse, err error) {
	response = CreateListDevopsScenarioFieldConfigResponse()
	err = client.DoAction(request, response)
	return
}

// ListDevopsScenarioFieldConfigWithChan invokes the devops_rdc.ListDevopsScenarioFieldConfig API asynchronously
func (client *Client) ListDevopsScenarioFieldConfigWithChan(request *ListDevopsScenarioFieldConfigRequest) (<-chan *ListDevopsScenarioFieldConfigResponse, <-chan error) {
	responseChan := make(chan *ListDevopsScenarioFieldConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDevopsScenarioFieldConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDevopsScenarioFieldConfigWithCallback invokes the devops_rdc.ListDevopsScenarioFieldConfig API asynchronously
func (client *Client) ListDevopsScenarioFieldConfigWithCallback(request *ListDevopsScenarioFieldConfigRequest, callback func(response *ListDevopsScenarioFieldConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDevopsScenarioFieldConfigResponse
		var err error
		defer close(result)
		response, err = client.ListDevopsScenarioFieldConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDevopsScenarioFieldConfigRequest is the request struct for api ListDevopsScenarioFieldConfig
type ListDevopsScenarioFieldConfigRequest struct {
	*requests.RpcRequest
	ProjectId string `position:"Body" name:"ProjectId"`
	OrgId     string `position:"Body" name:"OrgId"`
}

// ListDevopsScenarioFieldConfigResponse is the response struct for api ListDevopsScenarioFieldConfig
type ListDevopsScenarioFieldConfigResponse struct {
	*responses.BaseResponse
	Successful bool                  `json:"Successful" xml:"Successful"`
	ErrorCode  string                `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg   string                `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId  string                `json:"RequestId" xml:"RequestId"`
	Object     []ScenarioFieldConfig `json:"Object" xml:"Object"`
}

// CreateListDevopsScenarioFieldConfigRequest creates a request to invoke ListDevopsScenarioFieldConfig API
func CreateListDevopsScenarioFieldConfigRequest() (request *ListDevopsScenarioFieldConfigRequest) {
	request = &ListDevopsScenarioFieldConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("devops-rdc", "2020-03-03", "ListDevopsScenarioFieldConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateListDevopsScenarioFieldConfigResponse creates a response to parse from ListDevopsScenarioFieldConfig response
func CreateListDevopsScenarioFieldConfigResponse() (response *ListDevopsScenarioFieldConfigResponse) {
	response = &ListDevopsScenarioFieldConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
