package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInitializationStatus invokes the dts.DescribeInitializationStatus API synchronously
func (client *Client) DescribeInitializationStatus(request *DescribeInitializationStatusRequest) (response *DescribeInitializationStatusResponse, err error) {
	response = CreateDescribeInitializationStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInitializationStatusWithChan invokes the dts.DescribeInitializationStatus API asynchronously
func (client *Client) DescribeInitializationStatusWithChan(request *DescribeInitializationStatusRequest) (<-chan *DescribeInitializationStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeInitializationStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInitializationStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInitializationStatusWithCallback invokes the dts.DescribeInitializationStatus API asynchronously
func (client *Client) DescribeInitializationStatusWithCallback(request *DescribeInitializationStatusRequest, callback func(response *DescribeInitializationStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInitializationStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeInitializationStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInitializationStatusRequest is the request struct for api DescribeInitializationStatus
type DescribeInitializationStatusRequest struct {
	*requests.RpcRequest
	PageNum              requests.Integer `position:"Query" name:"PageNum"`
	OwnerId              string           `position:"Query" name:"OwnerId"`
	SynchronizationJobId string           `position:"Query" name:"SynchronizationJobId"`
	AccountId            string           `position:"Query" name:"AccountId"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
}

// DescribeInitializationStatusResponse is the response struct for api DescribeInitializationStatus
type DescribeInitializationStatusResponse struct {
	*responses.BaseResponse
	ErrCode                        string                          `json:"ErrCode" xml:"ErrCode"`
	ErrMessage                     string                          `json:"ErrMessage" xml:"ErrMessage"`
	RequestId                      string                          `json:"RequestId" xml:"RequestId"`
	Success                        string                          `json:"Success" xml:"Success"`
	DataInitializationDetails      []DataInitializationDetail      `json:"DataInitializationDetails" xml:"DataInitializationDetails"`
	DataSynchronizationDetails     []DataSynchronizationDetail     `json:"DataSynchronizationDetails" xml:"DataSynchronizationDetails"`
	StructureInitializationDetails []StructureInitializationDetail `json:"StructureInitializationDetails" xml:"StructureInitializationDetails"`
}

// CreateDescribeInitializationStatusRequest creates a request to invoke DescribeInitializationStatus API
func CreateDescribeInitializationStatusRequest() (request *DescribeInitializationStatusRequest) {
	request = &DescribeInitializationStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "DescribeInitializationStatus", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeInitializationStatusResponse creates a response to parse from DescribeInitializationStatus response
func CreateDescribeInitializationStatusResponse() (response *DescribeInitializationStatusResponse) {
	response = &DescribeInitializationStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
