package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ShieldPrecheck invokes the dts.ShieldPrecheck API synchronously
func (client *Client) ShieldPrecheck(request *ShieldPrecheckRequest) (response *ShieldPrecheckResponse, err error) {
	response = CreateShieldPrecheckResponse()
	err = client.DoAction(request, response)
	return
}

// ShieldPrecheckWithChan invokes the dts.ShieldPrecheck API asynchronously
func (client *Client) ShieldPrecheckWithChan(request *ShieldPrecheckRequest) (<-chan *ShieldPrecheckResponse, <-chan error) {
	responseChan := make(chan *ShieldPrecheckResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ShieldPrecheck(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ShieldPrecheckWithCallback invokes the dts.ShieldPrecheck API asynchronously
func (client *Client) ShieldPrecheckWithCallback(request *ShieldPrecheckRequest, callback func(response *ShieldPrecheckResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ShieldPrecheckResponse
		var err error
		defer close(result)
		response, err = client.ShieldPrecheck(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ShieldPrecheckRequest is the request struct for api ShieldPrecheck
type ShieldPrecheckRequest struct {
	*requests.RpcRequest
	PrecheckItems string `position:"Query" name:"PrecheckItems"`
	DtsInstanceId string `position:"Query" name:"DtsInstanceId"`
}

// ShieldPrecheckResponse is the response struct for api ShieldPrecheck
type ShieldPrecheckResponse struct {
	*responses.BaseResponse
	ErrCode    string `json:"ErrCode" xml:"ErrCode"`
	ErrMessage string `json:"ErrMessage" xml:"ErrMessage"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Success    bool   `json:"Success" xml:"Success"`
}

// CreateShieldPrecheckRequest creates a request to invoke ShieldPrecheck API
func CreateShieldPrecheckRequest() (request *ShieldPrecheckRequest) {
	request = &ShieldPrecheckRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "ShieldPrecheck", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateShieldPrecheckResponse creates a response to parse from ShieldPrecheck response
func CreateShieldPrecheckResponse() (response *ShieldPrecheckResponse) {
	response = &ShieldPrecheckResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
