package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpgradeTwoWay invokes the dts.UpgradeTwoWay API synchronously
func (client *Client) UpgradeTwoWay(request *UpgradeTwoWayRequest) (response *UpgradeTwoWayResponse, err error) {
	response = CreateUpgradeTwoWayResponse()
	err = client.DoAction(request, response)
	return
}

// UpgradeTwoWayWithChan invokes the dts.UpgradeTwoWay API asynchronously
func (client *Client) UpgradeTwoWayWithChan(request *UpgradeTwoWayRequest) (<-chan *UpgradeTwoWayResponse, <-chan error) {
	responseChan := make(chan *UpgradeTwoWayResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpgradeTwoWay(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpgradeTwoWayWithCallback invokes the dts.UpgradeTwoWay API asynchronously
func (client *Client) UpgradeTwoWayWithCallback(request *UpgradeTwoWayRequest, callback func(response *UpgradeTwoWayResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpgradeTwoWayResponse
		var err error
		defer close(result)
		response, err = client.UpgradeTwoWay(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpgradeTwoWayRequest is the request struct for api UpgradeTwoWay
type UpgradeTwoWayRequest struct {
	*requests.RpcRequest
	InstanceClass string `position:"Query" name:"InstanceClass"`
	InstanceId    string `position:"Query" name:"InstanceId"`
}

// UpgradeTwoWayResponse is the response struct for api UpgradeTwoWay
type UpgradeTwoWayResponse struct {
	*responses.BaseResponse
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	ErrCode        string `json:"ErrCode" xml:"ErrCode"`
	ErrMessage     string `json:"ErrMessage" xml:"ErrMessage"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateUpgradeTwoWayRequest creates a request to invoke UpgradeTwoWay API
func CreateUpgradeTwoWayRequest() (request *UpgradeTwoWayRequest) {
	request = &UpgradeTwoWayRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "UpgradeTwoWay", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpgradeTwoWayResponse creates a response to parse from UpgradeTwoWay response
func CreateUpgradeTwoWayResponse() (response *UpgradeTwoWayResponse) {
	response = &UpgradeTwoWayResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
