package dyplsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTotalPublicUrl invokes the dyplsapi.GetTotalPublicUrl API synchronously
func (client *Client) GetTotalPublicUrl(request *GetTotalPublicUrlRequest) (response *GetTotalPublicUrlResponse, err error) {
	response = CreateGetTotalPublicUrlResponse()
	err = client.DoAction(request, response)
	return
}

// GetTotalPublicUrlWithChan invokes the dyplsapi.GetTotalPublicUrl API asynchronously
func (client *Client) GetTotalPublicUrlWithChan(request *GetTotalPublicUrlRequest) (<-chan *GetTotalPublicUrlResponse, <-chan error) {
	responseChan := make(chan *GetTotalPublicUrlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTotalPublicUrl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTotalPublicUrlWithCallback invokes the dyplsapi.GetTotalPublicUrl API asynchronously
func (client *Client) GetTotalPublicUrlWithCallback(request *GetTotalPublicUrlRequest, callback func(response *GetTotalPublicUrlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTotalPublicUrlResponse
		var err error
		defer close(result)
		response, err = client.GetTotalPublicUrl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTotalPublicUrlRequest is the request struct for api GetTotalPublicUrl
type GetTotalPublicUrlRequest struct {
	*requests.RpcRequest
	CallId               string           `position:"Query" name:"CallId"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	CheckSubs            requests.Boolean `position:"Query" name:"CheckSubs"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	CallTime             string           `position:"Query" name:"CallTime"`
	PartnerKey           string           `position:"Query" name:"PartnerKey"`
}

// GetTotalPublicUrlResponse is the response struct for api GetTotalPublicUrl
type GetTotalPublicUrlResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetTotalPublicUrlRequest creates a request to invoke GetTotalPublicUrl API
func CreateGetTotalPublicUrlRequest() (request *GetTotalPublicUrlRequest) {
	request = &GetTotalPublicUrlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyplsapi", "2017-05-25", "GetTotalPublicUrl", "", "")
	request.Method = requests.POST
	return
}

// CreateGetTotalPublicUrlResponse creates a response to parse from GetTotalPublicUrl response
func CreateGetTotalPublicUrlResponse() (response *GetTotalPublicUrlResponse) {
	response = &GetTotalPublicUrlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
