package dypnsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateVerifyScheme invokes the dypnsapi.CreateVerifyScheme API synchronously
// api document: https://help.aliyun.com/api/dypnsapi/createverifyscheme.html
func (client *Client) CreateVerifyScheme(request *CreateVerifySchemeRequest) (response *CreateVerifySchemeResponse, err error) {
	response = CreateCreateVerifySchemeResponse()
	err = client.DoAction(request, response)
	return
}

// CreateVerifySchemeWithChan invokes the dypnsapi.CreateVerifyScheme API asynchronously
// api document: https://help.aliyun.com/api/dypnsapi/createverifyscheme.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateVerifySchemeWithChan(request *CreateVerifySchemeRequest) (<-chan *CreateVerifySchemeResponse, <-chan error) {
	responseChan := make(chan *CreateVerifySchemeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateVerifyScheme(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateVerifySchemeWithCallback invokes the dypnsapi.CreateVerifyScheme API asynchronously
// api document: https://help.aliyun.com/api/dypnsapi/createverifyscheme.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateVerifySchemeWithCallback(request *CreateVerifySchemeRequest, callback func(response *CreateVerifySchemeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateVerifySchemeResponse
		var err error
		defer close(result)
		response, err = client.CreateVerifyScheme(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateVerifySchemeRequest is the request struct for api CreateVerifyScheme
type CreateVerifySchemeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	BundleId             string           `position:"Query" name:"BundleId"`
	AppName              string           `position:"Query" name:"AppName"`
	PackSign             string           `position:"Query" name:"PackSign"`
	PackName             string           `position:"Query" name:"PackName"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OsType               string           `position:"Query" name:"OsType"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SchemeName           string           `position:"Query" name:"SchemeName"`
}

// CreateVerifySchemeResponse is the response struct for api CreateVerifyScheme
type CreateVerifySchemeResponse struct {
	*responses.BaseResponse
	RequestId           string              `json:"RequestId" xml:"RequestId"`
	Code                string              `json:"Code" xml:"Code"`
	Message             string              `json:"Message" xml:"Message"`
	GateVerifySchemeDTO GateVerifySchemeDTO `json:"GateVerifySchemeDTO" xml:"GateVerifySchemeDTO"`
}

// CreateCreateVerifySchemeRequest creates a request to invoke CreateVerifyScheme API
func CreateCreateVerifySchemeRequest() (request *CreateVerifySchemeRequest) {
	request = &CreateVerifySchemeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dypnsapi", "2017-05-25", "CreateVerifyScheme", "dypns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateVerifySchemeResponse creates a response to parse from CreateVerifyScheme response
func CreateCreateVerifySchemeResponse() (response *CreateVerifySchemeResponse) {
	response = &CreateVerifySchemeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
