package eas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetResourceServices invokes the eas.GetResourceServices API synchronously
// api document: https://help.aliyun.com/api/eas/getresourceservices.html
func (client *Client) GetResourceServices(request *GetResourceServicesRequest) (response *GetResourceServicesResponse, err error) {
	response = CreateGetResourceServicesResponse()
	err = client.DoAction(request, response)
	return
}

// GetResourceServicesWithChan invokes the eas.GetResourceServices API asynchronously
// api document: https://help.aliyun.com/api/eas/getresourceservices.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetResourceServicesWithChan(request *GetResourceServicesRequest) (<-chan *GetResourceServicesResponse, <-chan error) {
	responseChan := make(chan *GetResourceServicesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetResourceServices(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetResourceServicesWithCallback invokes the eas.GetResourceServices API asynchronously
// api document: https://help.aliyun.com/api/eas/getresourceservices.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetResourceServicesWithCallback(request *GetResourceServicesRequest, callback func(response *GetResourceServicesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetResourceServicesResponse
		var err error
		defer close(result)
		response, err = client.GetResourceServices(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetResourceServicesRequest is the request struct for api GetResourceServices
type GetResourceServicesRequest struct {
	*requests.RoaRequest
	ClusterId    string `position:"Path" name:"cluster_id"`
	ResourceName string `position:"Path" name:"resource_name"`
}

// GetResourceServicesResponse is the response struct for api GetResourceServices
type GetResourceServicesResponse struct {
	*responses.BaseResponse
}

// CreateGetResourceServicesRequest creates a request to invoke GetResourceServices API
func CreateGetResourceServicesRequest() (request *GetResourceServicesRequest) {
	request = &GetResourceServicesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("eas", "2018-05-22", "GetResourceServices", "/api/resources/[cluster_id]/[resource_name]/services", "", "")
	request.Method = requests.GET
	return
}

// CreateGetResourceServicesResponse creates a response to parse from GetResourceServices response
func CreateGetResourceServicesResponse() (response *GetResourceServicesResponse) {
	response = &GetResourceServicesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
