package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeKeyPairs invokes the ecs.DescribeKeyPairs API synchronously
func (client *Client) DescribeKeyPairs(request *DescribeKeyPairsRequest) (response *DescribeKeyPairsResponse, err error) {
	response = CreateDescribeKeyPairsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeKeyPairsWithChan invokes the ecs.DescribeKeyPairs API asynchronously
func (client *Client) DescribeKeyPairsWithChan(request *DescribeKeyPairsRequest) (<-chan *DescribeKeyPairsResponse, <-chan error) {
	responseChan := make(chan *DescribeKeyPairsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeKeyPairs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeKeyPairsWithCallback invokes the ecs.DescribeKeyPairs API asynchronously
func (client *Client) DescribeKeyPairsWithCallback(request *DescribeKeyPairsRequest, callback func(response *DescribeKeyPairsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeKeyPairsResponse
		var err error
		defer close(result)
		response, err = client.DescribeKeyPairs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeKeyPairsRequest is the request struct for api DescribeKeyPairs
type DescribeKeyPairsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer       `position:"Query" name:"ResourceOwnerId"`
	KeyPairFingerPrint   string                 `position:"Query" name:"KeyPairFingerPrint"`
	KeyPairName          string                 `position:"Query" name:"KeyPairName"`
	PageNumber           requests.Integer       `position:"Query" name:"PageNumber"`
	ResourceGroupId      string                 `position:"Query" name:"ResourceGroupId"`
	PageSize             requests.Integer       `position:"Query" name:"PageSize"`
	Tag                  *[]DescribeKeyPairsTag `position:"Query" name:"Tag"  type:"Repeated"`
	ResourceOwnerAccount string                 `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer       `position:"Query" name:"OwnerId"`
}

// DescribeKeyPairsTag is a repeated param struct in DescribeKeyPairsRequest
type DescribeKeyPairsTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// DescribeKeyPairsResponse is the response struct for api DescribeKeyPairs
type DescribeKeyPairsResponse struct {
	*responses.BaseResponse
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	TotalCount int      `json:"TotalCount" xml:"TotalCount"`
	PageNumber int      `json:"PageNumber" xml:"PageNumber"`
	PageSize   int      `json:"PageSize" xml:"PageSize"`
	KeyPairs   KeyPairs `json:"KeyPairs" xml:"KeyPairs"`
}

// CreateDescribeKeyPairsRequest creates a request to invoke DescribeKeyPairs API
func CreateDescribeKeyPairsRequest() (request *DescribeKeyPairsRequest) {
	request = &DescribeKeyPairsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "DescribeKeyPairs", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeKeyPairsResponse creates a response to parse from DescribeKeyPairs response
func CreateDescribeKeyPairsResponse() (response *DescribeKeyPairsResponse) {
	response = &DescribeKeyPairsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
