package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddQueue invokes the ehpc.AddQueue API synchronously
func (client *Client) AddQueue(request *AddQueueRequest) (response *AddQueueResponse, err error) {
	response = CreateAddQueueResponse()
	err = client.DoAction(request, response)
	return
}

// AddQueueWithChan invokes the ehpc.AddQueue API asynchronously
func (client *Client) AddQueueWithChan(request *AddQueueRequest) (<-chan *AddQueueResponse, <-chan error) {
	responseChan := make(chan *AddQueueResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddQueue(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddQueueWithCallback invokes the ehpc.AddQueue API asynchronously
func (client *Client) AddQueueWithCallback(request *AddQueueRequest, callback func(response *AddQueueResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddQueueResponse
		var err error
		defer close(result)
		response, err = client.AddQueue(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddQueueRequest is the request struct for api AddQueue
type AddQueueRequest struct {
	*requests.RpcRequest
	QueueName string `position:"Query" name:"QueueName"`
	ClusterId string `position:"Query" name:"ClusterId"`
}

// AddQueueResponse is the response struct for api AddQueue
type AddQueueResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddQueueRequest creates a request to invoke AddQueue API
func CreateAddQueueRequest() (request *AddQueueRequest) {
	request = &AddQueueRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "AddQueue", "", "")
	request.Method = requests.GET
	return
}

// CreateAddQueueResponse creates a response to parse from AddQueue response
func CreateAddQueueResponse() (response *AddQueueResponse) {
	response = &AddQueueResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
