package eipanycast

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AllocateAnycastEipAddress invokes the eipanycast.AllocateAnycastEipAddress API synchronously
func (client *Client) AllocateAnycastEipAddress(request *AllocateAnycastEipAddressRequest) (response *AllocateAnycastEipAddressResponse, err error) {
	response = CreateAllocateAnycastEipAddressResponse()
	err = client.DoAction(request, response)
	return
}

// AllocateAnycastEipAddressWithChan invokes the eipanycast.AllocateAnycastEipAddress API asynchronously
func (client *Client) AllocateAnycastEipAddressWithChan(request *AllocateAnycastEipAddressRequest) (<-chan *AllocateAnycastEipAddressResponse, <-chan error) {
	responseChan := make(chan *AllocateAnycastEipAddressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AllocateAnycastEipAddress(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AllocateAnycastEipAddressWithCallback invokes the eipanycast.AllocateAnycastEipAddress API asynchronously
func (client *Client) AllocateAnycastEipAddressWithCallback(request *AllocateAnycastEipAddressRequest, callback func(response *AllocateAnycastEipAddressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AllocateAnycastEipAddressResponse
		var err error
		defer close(result)
		response, err = client.AllocateAnycastEipAddress(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AllocateAnycastEipAddressRequest is the request struct for api AllocateAnycastEipAddress
type AllocateAnycastEipAddressRequest struct {
	*requests.RpcRequest
	Bandwidth          string `position:"Query" name:"Bandwidth"`
	ServiceLocation    string `position:"Query" name:"ServiceLocation"`
	ClientToken        string `position:"Query" name:"ClientToken"`
	Description        string `position:"Query" name:"Description"`
	InternetChargeType string `position:"Query" name:"InternetChargeType"`
	Name               string `position:"Query" name:"Name"`
	InstanceChargeType string `position:"Query" name:"InstanceChargeType"`
}

// AllocateAnycastEipAddressResponse is the response struct for api AllocateAnycastEipAddress
type AllocateAnycastEipAddressResponse struct {
	*responses.BaseResponse
	AnycastId string `json:"AnycastId" xml:"AnycastId"`
	OrderId   string `json:"OrderId" xml:"OrderId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAllocateAnycastEipAddressRequest creates a request to invoke AllocateAnycastEipAddress API
func CreateAllocateAnycastEipAddressRequest() (request *AllocateAnycastEipAddressRequest) {
	request = &AllocateAnycastEipAddressRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Eipanycast", "2020-03-09", "AllocateAnycastEipAddress", "eipanycast", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAllocateAnycastEipAddressResponse creates a response to parse from AllocateAnycastEipAddress response
func CreateAllocateAnycastEipAddressResponse() (response *AllocateAnycastEipAddressResponse) {
	response = &AllocateAnycastEipAddressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
