package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateExecutionPlan invokes the emr.CreateExecutionPlan API synchronously
func (client *Client) CreateExecutionPlan(request *CreateExecutionPlanRequest) (response *CreateExecutionPlanResponse, err error) {
	response = CreateCreateExecutionPlanResponse()
	err = client.DoAction(request, response)
	return
}

// CreateExecutionPlanWithChan invokes the emr.CreateExecutionPlan API asynchronously
func (client *Client) CreateExecutionPlanWithChan(request *CreateExecutionPlanRequest) (<-chan *CreateExecutionPlanResponse, <-chan error) {
	responseChan := make(chan *CreateExecutionPlanResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateExecutionPlan(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateExecutionPlanWithCallback invokes the emr.CreateExecutionPlan API asynchronously
func (client *Client) CreateExecutionPlanWithCallback(request *CreateExecutionPlanRequest, callback func(response *CreateExecutionPlanResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateExecutionPlanResponse
		var err error
		defer close(result)
		response, err = client.CreateExecutionPlan(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateExecutionPlanRequest is the request struct for api CreateExecutionPlan
type CreateExecutionPlanRequest struct {
	*requests.RpcRequest
	ResourceOwnerId        requests.Integer                      `position:"Query" name:"ResourceOwnerId"`
	TimeInterval           requests.Integer                      `position:"Query" name:"TimeInterval"`
	LogPath                string                                `position:"Query" name:"LogPath"`
	ClusterName            string                                `position:"Query" name:"ClusterName"`
	Configurations         string                                `position:"Query" name:"Configurations"`
	CreateClusterOnDemand  requests.Boolean                      `position:"Query" name:"CreateClusterOnDemand"`
	StartTime              requests.Integer                      `position:"Query" name:"StartTime"`
	BootstrapAction        *[]CreateExecutionPlanBootstrapAction `position:"Query" name:"BootstrapAction"  type:"Repeated"`
	EmrVer                 string                                `position:"Query" name:"EmrVer"`
	IsOpenPublicIp         requests.Boolean                      `position:"Query" name:"IsOpenPublicIp"`
	InstanceGeneration     string                                `position:"Query" name:"InstanceGeneration"`
	ClusterType            string                                `position:"Query" name:"ClusterType"`
	VSwitchId              string                                `position:"Query" name:"VSwitchId"`
	OptionSoftWareList     *[]string                             `position:"Query" name:"OptionSoftWareList"  type:"Repeated"`
	NetType                string                                `position:"Query" name:"NetType"`
	EcsOrder               *[]CreateExecutionPlanEcsOrder        `position:"Query" name:"EcsOrder"  type:"Repeated"`
	Name                   string                                `position:"Query" name:"Name"`
	ZoneId                 string                                `position:"Query" name:"ZoneId"`
	UseCustomHiveMetaDB    requests.Boolean                      `position:"Query" name:"UseCustomHiveMetaDB"`
	InitCustomHiveMetaDB   requests.Boolean                      `position:"Query" name:"InitCustomHiveMetaDB"`
	IoOptimized            requests.Boolean                      `position:"Query" name:"IoOptimized"`
	SecurityGroupId        string                                `position:"Query" name:"SecurityGroupId"`
	EasEnable              requests.Boolean                      `position:"Query" name:"EasEnable"`
	JobIdList              *[]string                             `position:"Query" name:"JobIdList"  type:"Repeated"`
	DayOfMonth             string                                `position:"Query" name:"DayOfMonth"`
	UseLocalMetaDb         requests.Boolean                      `position:"Query" name:"UseLocalMetaDb"`
	UserDefinedEmrEcsRole  string                                `position:"Query" name:"UserDefinedEmrEcsRole"`
	ClusterId              string                                `position:"Query" name:"ClusterId"`
	TimeUnit               string                                `position:"Query" name:"TimeUnit"`
	VpcId                  string                                `position:"Query" name:"VpcId"`
	WorkflowDefinition     string                                `position:"Query" name:"WorkflowDefinition"`
	DayOfWeek              string                                `position:"Query" name:"DayOfWeek"`
	Strategy               string                                `position:"Query" name:"Strategy"`
	Config                 *[]CreateExecutionPlanConfig          `position:"Query" name:"Config"  type:"Repeated"`
	HighAvailabilityEnable requests.Boolean                      `position:"Query" name:"HighAvailabilityEnable"`
	LogEnable              requests.Boolean                      `position:"Query" name:"LogEnable"`
}

// CreateExecutionPlanBootstrapAction is a repeated param struct in CreateExecutionPlanRequest
type CreateExecutionPlanBootstrapAction struct {
	Path                  string `name:"Path"`
	ExecutionTarget       string `name:"ExecutionTarget"`
	ExecutionMoment       string `name:"ExecutionMoment"`
	Arg                   string `name:"Arg"`
	Name                  string `name:"Name"`
	ExecutionFailStrategy string `name:"ExecutionFailStrategy"`
}

// CreateExecutionPlanEcsOrder is a repeated param struct in CreateExecutionPlanRequest
type CreateExecutionPlanEcsOrder struct {
	NodeType     string `name:"NodeType"`
	DiskCount    string `name:"DiskCount"`
	NodeCount    string `name:"NodeCount"`
	DiskCapacity string `name:"DiskCapacity"`
	Index        string `name:"Index"`
	InstanceType string `name:"InstanceType"`
	DiskType     string `name:"DiskType"`
}

// CreateExecutionPlanConfig is a repeated param struct in CreateExecutionPlanRequest
type CreateExecutionPlanConfig struct {
	ConfigKey   string `name:"ConfigKey"`
	FileName    string `name:"FileName"`
	Encrypt     string `name:"Encrypt"`
	Replace     string `name:"Replace"`
	ConfigValue string `name:"ConfigValue"`
	ServiceName string `name:"ServiceName"`
}

// CreateExecutionPlanResponse is the response struct for api CreateExecutionPlan
type CreateExecutionPlanResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Id        string `json:"Id" xml:"Id"`
}

// CreateCreateExecutionPlanRequest creates a request to invoke CreateExecutionPlan API
func CreateCreateExecutionPlanRequest() (request *CreateExecutionPlanRequest) {
	request = &CreateExecutionPlanRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "CreateExecutionPlan", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateExecutionPlanResponse creates a response to parse from CreateExecutionPlan response
func CreateCreateExecutionPlanResponse() (response *CreateExecutionPlanResponse) {
	response = &CreateExecutionPlanResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
