package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListLibraryInstallTasks invokes the emr.ListLibraryInstallTasks API synchronously
func (client *Client) ListLibraryInstallTasks(request *ListLibraryInstallTasksRequest) (response *ListLibraryInstallTasksResponse, err error) {
	response = CreateListLibraryInstallTasksResponse()
	err = client.DoAction(request, response)
	return
}

// ListLibraryInstallTasksWithChan invokes the emr.ListLibraryInstallTasks API asynchronously
func (client *Client) ListLibraryInstallTasksWithChan(request *ListLibraryInstallTasksRequest) (<-chan *ListLibraryInstallTasksResponse, <-chan error) {
	responseChan := make(chan *ListLibraryInstallTasksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListLibraryInstallTasks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListLibraryInstallTasksWithCallback invokes the emr.ListLibraryInstallTasks API asynchronously
func (client *Client) ListLibraryInstallTasksWithCallback(request *ListLibraryInstallTasksRequest, callback func(response *ListLibraryInstallTasksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListLibraryInstallTasksResponse
		var err error
		defer close(result)
		response, err = client.ListLibraryInstallTasks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListLibraryInstallTasksRequest is the request struct for api ListLibraryInstallTasks
type ListLibraryInstallTasksRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageCount       requests.Integer `position:"Query" name:"PageCount"`
	OrderMode       string           `position:"Query" name:"OrderMode"`
	ClusterBizId    string           `position:"Query" name:"ClusterBizId"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	Limit           requests.Integer `position:"Query" name:"Limit"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	CurrentSize     requests.Integer `position:"Query" name:"CurrentSize"`
	OrderField      string           `position:"Query" name:"OrderField"`
	LibraryBizId    string           `position:"Query" name:"LibraryBizId"`
}

// ListLibraryInstallTasksResponse is the response struct for api ListLibraryInstallTasks
type ListLibraryInstallTasksResponse struct {
	*responses.BaseResponse
	RequestId  string                         `json:"RequestId" xml:"RequestId"`
	PageNumber int                            `json:"PageNumber" xml:"PageNumber"`
	PageSize   int                            `json:"PageSize" xml:"PageSize"`
	TotalCount int                            `json:"TotalCount" xml:"TotalCount"`
	NextToken  string                         `json:"NextToken" xml:"NextToken"`
	Items      ItemsInListLibraryInstallTasks `json:"Items" xml:"Items"`
}

// CreateListLibraryInstallTasksRequest creates a request to invoke ListLibraryInstallTasks API
func CreateListLibraryInstallTasksRequest() (request *ListLibraryInstallTasksRequest) {
	request = &ListLibraryInstallTasksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListLibraryInstallTasks", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListLibraryInstallTasksResponse creates a response to parse from ListLibraryInstallTasks response
func CreateListLibraryInstallTasksResponse() (response *ListLibraryInstallTasksResponse) {
	response = &ListLibraryInstallTasksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
