package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDataDownloadURL invokes the ens.DescribeDataDownloadURL API synchronously
func (client *Client) DescribeDataDownloadURL(request *DescribeDataDownloadURLRequest) (response *DescribeDataDownloadURLResponse, err error) {
	response = CreateDescribeDataDownloadURLResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDataDownloadURLWithChan invokes the ens.DescribeDataDownloadURL API asynchronously
func (client *Client) DescribeDataDownloadURLWithChan(request *DescribeDataDownloadURLRequest) (<-chan *DescribeDataDownloadURLResponse, <-chan error) {
	responseChan := make(chan *DescribeDataDownloadURLResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDataDownloadURL(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDataDownloadURLWithCallback invokes the ens.DescribeDataDownloadURL API asynchronously
func (client *Client) DescribeDataDownloadURLWithCallback(request *DescribeDataDownloadURLRequest, callback func(response *DescribeDataDownloadURLResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDataDownloadURLResponse
		var err error
		defer close(result)
		response, err = client.DescribeDataDownloadURL(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDataDownloadURLRequest is the request struct for api DescribeDataDownloadURL
type DescribeDataDownloadURLRequest struct {
	*requests.RpcRequest
	ExpireTimeout        requests.Integer `position:"Query" name:"ExpireTimeout"`
	ServerFilterStrategy string           `position:"Query" name:"ServerFilterStrategy"`
	DataName             string           `position:"Query" name:"DataName"`
	DataVersion          string           `position:"Query" name:"DataVersion"`
	AppId                string           `position:"Query" name:"AppId"`
}

// DescribeDataDownloadURLResponse is the response struct for api DescribeDataDownloadURL
type DescribeDataDownloadURLResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int64  `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeDataDownloadURLRequest creates a request to invoke DescribeDataDownloadURL API
func CreateDescribeDataDownloadURLRequest() (request *DescribeDataDownloadURLRequest) {
	request = &DescribeDataDownloadURLRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DescribeDataDownloadURL", "ens", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeDataDownloadURLResponse creates a response to parse from DescribeDataDownloadURL response
func CreateDescribeDataDownloadURLResponse() (response *DescribeDataDownloadURLResponse) {
	response = &DescribeDataDownloadURLResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
