package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetLoadBalancerTCPListenerAttribute invokes the ens.SetLoadBalancerTCPListenerAttribute API synchronously
func (client *Client) SetLoadBalancerTCPListenerAttribute(request *SetLoadBalancerTCPListenerAttributeRequest) (response *SetLoadBalancerTCPListenerAttributeResponse, err error) {
	response = CreateSetLoadBalancerTCPListenerAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// SetLoadBalancerTCPListenerAttributeWithChan invokes the ens.SetLoadBalancerTCPListenerAttribute API asynchronously
func (client *Client) SetLoadBalancerTCPListenerAttributeWithChan(request *SetLoadBalancerTCPListenerAttributeRequest) (<-chan *SetLoadBalancerTCPListenerAttributeResponse, <-chan error) {
	responseChan := make(chan *SetLoadBalancerTCPListenerAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetLoadBalancerTCPListenerAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetLoadBalancerTCPListenerAttributeWithCallback invokes the ens.SetLoadBalancerTCPListenerAttribute API asynchronously
func (client *Client) SetLoadBalancerTCPListenerAttributeWithCallback(request *SetLoadBalancerTCPListenerAttributeRequest, callback func(response *SetLoadBalancerTCPListenerAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetLoadBalancerTCPListenerAttributeResponse
		var err error
		defer close(result)
		response, err = client.SetLoadBalancerTCPListenerAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetLoadBalancerTCPListenerAttributeRequest is the request struct for api SetLoadBalancerTCPListenerAttribute
type SetLoadBalancerTCPListenerAttributeRequest struct {
	*requests.RpcRequest
	HealthCheckURI            string           `position:"Query" name:"HealthCheckURI"`
	Protocol                  string           `position:"Query" name:"Protocol"`
	EstablishedTimeout        requests.Integer `position:"Query" name:"EstablishedTimeout"`
	PersistenceTimeout        requests.Integer `position:"Query" name:"PersistenceTimeout"`
	HealthCheckDomain         string           `position:"Query" name:"HealthCheckDomain"`
	LoadBalancerId            string           `position:"Query" name:"LoadBalancerId"`
	HealthCheckInterval       requests.Integer `position:"Query" name:"HealthCheckInterval"`
	HealthCheckConnectTimeout requests.Integer `position:"Query" name:"HealthCheckConnectTimeout"`
	Description               string           `position:"Query" name:"Description"`
	UnhealthyThreshold        requests.Integer `position:"Query" name:"UnhealthyThreshold"`
	HealthyThreshold          requests.Integer `position:"Query" name:"HealthyThreshold"`
	Scheduler                 string           `position:"Query" name:"Scheduler"`
	ListenerPort              requests.Integer `position:"Query" name:"ListenerPort"`
	HealthCheckType           string           `position:"Query" name:"HealthCheckType"`
	HealthCheckConnectPort    requests.Integer `position:"Query" name:"HealthCheckConnectPort"`
	HealthCheckHttpCode       string           `position:"Query" name:"HealthCheckHttpCode"`
}

// SetLoadBalancerTCPListenerAttributeResponse is the response struct for api SetLoadBalancerTCPListenerAttribute
type SetLoadBalancerTCPListenerAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetLoadBalancerTCPListenerAttributeRequest creates a request to invoke SetLoadBalancerTCPListenerAttribute API
func CreateSetLoadBalancerTCPListenerAttributeRequest() (request *SetLoadBalancerTCPListenerAttributeRequest) {
	request = &SetLoadBalancerTCPListenerAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "SetLoadBalancerTCPListenerAttribute", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetLoadBalancerTCPListenerAttributeResponse creates a response to parse from SetLoadBalancerTCPListenerAttribute response
func CreateSetLoadBalancerTCPListenerAttributeResponse() (response *SetLoadBalancerTCPListenerAttributeResponse) {
	response = &SetLoadBalancerTCPListenerAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
