package foas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckRawPlanJson invokes the foas.CheckRawPlanJson API synchronously
// api document: https://help.aliyun.com/api/foas/checkrawplanjson.html
func (client *Client) CheckRawPlanJson(request *CheckRawPlanJsonRequest) (response *CheckRawPlanJsonResponse, err error) {
	response = CreateCheckRawPlanJsonResponse()
	err = client.DoAction(request, response)
	return
}

// CheckRawPlanJsonWithChan invokes the foas.CheckRawPlanJson API asynchronously
// api document: https://help.aliyun.com/api/foas/checkrawplanjson.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CheckRawPlanJsonWithChan(request *CheckRawPlanJsonRequest) (<-chan *CheckRawPlanJsonResponse, <-chan error) {
	responseChan := make(chan *CheckRawPlanJsonResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckRawPlanJson(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckRawPlanJsonWithCallback invokes the foas.CheckRawPlanJson API asynchronously
// api document: https://help.aliyun.com/api/foas/checkrawplanjson.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CheckRawPlanJsonWithCallback(request *CheckRawPlanJsonRequest, callback func(response *CheckRawPlanJsonResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckRawPlanJsonResponse
		var err error
		defer close(result)
		response, err = client.CheckRawPlanJson(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckRawPlanJsonRequest is the request struct for api CheckRawPlanJson
type CheckRawPlanJsonRequest struct {
	*requests.RoaRequest
	ProjectName string `position:"Path" name:"projectName"`
	SessionId   string `position:"Query" name:"sessionId"`
	JobName     string `position:"Path" name:"jobName"`
}

// CheckRawPlanJsonResponse is the response struct for api CheckRawPlanJson
type CheckRawPlanJsonResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	PlanJsonInfo PlanJsonInfo `json:"PlanJsonInfo" xml:"PlanJsonInfo"`
}

// CreateCheckRawPlanJsonRequest creates a request to invoke CheckRawPlanJson API
func CreateCheckRawPlanJsonRequest() (request *CheckRawPlanJsonRequest) {
	request = &CheckRawPlanJsonRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("foas", "2018-11-11", "CheckRawPlanJson", "/api/v2/projects/[projectName]/jobs/[jobName]/planjson/check", "foas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateCheckRawPlanJsonResponse creates a response to parse from CheckRawPlanJson response
func CreateCheckRawPlanJsonResponse() (response *CheckRawPlanJsonResponse) {
	response = &CheckRawPlanJsonResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
