package foas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetInstanceHistoryAutoScalePlanList invokes the foas.GetInstanceHistoryAutoScalePlanList API synchronously
// api document: https://help.aliyun.com/api/foas/getinstancehistoryautoscaleplanlist.html
func (client *Client) GetInstanceHistoryAutoScalePlanList(request *GetInstanceHistoryAutoScalePlanListRequest) (response *GetInstanceHistoryAutoScalePlanListResponse, err error) {
	response = CreateGetInstanceHistoryAutoScalePlanListResponse()
	err = client.DoAction(request, response)
	return
}

// GetInstanceHistoryAutoScalePlanListWithChan invokes the foas.GetInstanceHistoryAutoScalePlanList API asynchronously
// api document: https://help.aliyun.com/api/foas/getinstancehistoryautoscaleplanlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetInstanceHistoryAutoScalePlanListWithChan(request *GetInstanceHistoryAutoScalePlanListRequest) (<-chan *GetInstanceHistoryAutoScalePlanListResponse, <-chan error) {
	responseChan := make(chan *GetInstanceHistoryAutoScalePlanListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetInstanceHistoryAutoScalePlanList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetInstanceHistoryAutoScalePlanListWithCallback invokes the foas.GetInstanceHistoryAutoScalePlanList API asynchronously
// api document: https://help.aliyun.com/api/foas/getinstancehistoryautoscaleplanlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetInstanceHistoryAutoScalePlanListWithCallback(request *GetInstanceHistoryAutoScalePlanListRequest, callback func(response *GetInstanceHistoryAutoScalePlanListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetInstanceHistoryAutoScalePlanListResponse
		var err error
		defer close(result)
		response, err = client.GetInstanceHistoryAutoScalePlanList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetInstanceHistoryAutoScalePlanListRequest is the request struct for api GetInstanceHistoryAutoScalePlanList
type GetInstanceHistoryAutoScalePlanListRequest struct {
	*requests.RoaRequest
	ProjectName string           `position:"Path" name:"projectName"`
	InstanceId  requests.Integer `position:"Path" name:"instanceId"`
	JobName     string           `position:"Path" name:"jobName"`
}

// GetInstanceHistoryAutoScalePlanListResponse is the response struct for api GetInstanceHistoryAutoScalePlanList
type GetInstanceHistoryAutoScalePlanListResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	PlanList  PlanList `json:"PlanList" xml:"PlanList"`
}

// CreateGetInstanceHistoryAutoScalePlanListRequest creates a request to invoke GetInstanceHistoryAutoScalePlanList API
func CreateGetInstanceHistoryAutoScalePlanListRequest() (request *GetInstanceHistoryAutoScalePlanListRequest) {
	request = &GetInstanceHistoryAutoScalePlanListRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("foas", "2018-11-11", "GetInstanceHistoryAutoScalePlanList", "/api/v2/projects/[projectName]/jobs/[jobName]/instance/[instanceId]/autoscale/planlist", "foas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetInstanceHistoryAutoScalePlanListResponse creates a response to parse from GetInstanceHistoryAutoScalePlanList response
func CreateGetInstanceHistoryAutoScalePlanListResponse() (response *GetInstanceHistoryAutoScalePlanListResponse) {
	response = &GetInstanceHistoryAutoScalePlanListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
