package foas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetJob invokes the foas.GetJob API synchronously
// api document: https://help.aliyun.com/api/foas/getjob.html
func (client *Client) GetJob(request *GetJobRequest) (response *GetJobResponse, err error) {
	response = CreateGetJobResponse()
	err = client.DoAction(request, response)
	return
}

// GetJobWithChan invokes the foas.GetJob API asynchronously
// api document: https://help.aliyun.com/api/foas/getjob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetJobWithChan(request *GetJobRequest) (<-chan *GetJobResponse, <-chan error) {
	responseChan := make(chan *GetJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetJobWithCallback invokes the foas.GetJob API asynchronously
// api document: https://help.aliyun.com/api/foas/getjob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetJobWithCallback(request *GetJobRequest, callback func(response *GetJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetJobResponse
		var err error
		defer close(result)
		response, err = client.GetJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetJobRequest is the request struct for api GetJob
type GetJobRequest struct {
	*requests.RoaRequest
	ProjectName string `position:"Path" name:"projectName"`
	JobName     string `position:"Path" name:"jobName"`
}

// GetJobResponse is the response struct for api GetJob
type GetJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Job       Job    `json:"Job" xml:"Job"`
}

// CreateGetJobRequest creates a request to invoke GetJob API
func CreateGetJobRequest() (request *GetJobRequest) {
	request = &GetJobRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("foas", "2018-11-11", "GetJob", "/api/v2/projects/[projectName]/jobs/[jobName]", "foas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetJobResponse creates a response to parse from GetJob response
func CreateGetJobResponse() (response *GetJobResponse) {
	response = &GetJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
