package foas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetRefPackageJob invokes the foas.GetRefPackageJob API synchronously
// api document: https://help.aliyun.com/api/foas/getrefpackagejob.html
func (client *Client) GetRefPackageJob(request *GetRefPackageJobRequest) (response *GetRefPackageJobResponse, err error) {
	response = CreateGetRefPackageJobResponse()
	err = client.DoAction(request, response)
	return
}

// GetRefPackageJobWithChan invokes the foas.GetRefPackageJob API asynchronously
// api document: https://help.aliyun.com/api/foas/getrefpackagejob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetRefPackageJobWithChan(request *GetRefPackageJobRequest) (<-chan *GetRefPackageJobResponse, <-chan error) {
	responseChan := make(chan *GetRefPackageJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetRefPackageJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetRefPackageJobWithCallback invokes the foas.GetRefPackageJob API asynchronously
// api document: https://help.aliyun.com/api/foas/getrefpackagejob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetRefPackageJobWithCallback(request *GetRefPackageJobRequest, callback func(response *GetRefPackageJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetRefPackageJobResponse
		var err error
		defer close(result)
		response, err = client.GetRefPackageJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetRefPackageJobRequest is the request struct for api GetRefPackageJob
type GetRefPackageJobRequest struct {
	*requests.RoaRequest
	ProjectName string           `position:"Path" name:"projectName"`
	PackageName string           `position:"Path" name:"packageName"`
	PageSize    requests.Integer `position:"Query" name:"pageSize"`
	PageIndex   requests.Integer `position:"Query" name:"pageIndex"`
}

// GetRefPackageJobResponse is the response struct for api GetRefPackageJob
type GetRefPackageJobResponse struct {
	*responses.BaseResponse
	RequestId  string                 `json:"RequestId" xml:"RequestId"`
	PageIndex  int                    `json:"PageIndex" xml:"PageIndex"`
	PageSize   int                    `json:"PageSize" xml:"PageSize"`
	TotalCount int64                  `json:"TotalCount" xml:"TotalCount"`
	TotalPage  int                    `json:"TotalPage" xml:"TotalPage"`
	Jobs       JobsInGetRefPackageJob `json:"Jobs" xml:"Jobs"`
}

// CreateGetRefPackageJobRequest creates a request to invoke GetRefPackageJob API
func CreateGetRefPackageJobRequest() (request *GetRefPackageJobRequest) {
	request = &GetRefPackageJobRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("foas", "2018-11-11", "GetRefPackageJob", "/api/v2/projects/[projectName]/packages/[packageName]/jobs", "foas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetRefPackageJobResponse creates a response to parse from GetRefPackageJob response
func CreateGetRefPackageJobResponse() (response *GetRefPackageJobResponse) {
	response = &GetRefPackageJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
