package foas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OfflineJob invokes the foas.OfflineJob API synchronously
// api document: https://help.aliyun.com/api/foas/offlinejob.html
func (client *Client) OfflineJob(request *OfflineJobRequest) (response *OfflineJobResponse, err error) {
	response = CreateOfflineJobResponse()
	err = client.DoAction(request, response)
	return
}

// OfflineJobWithChan invokes the foas.OfflineJob API asynchronously
// api document: https://help.aliyun.com/api/foas/offlinejob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OfflineJobWithChan(request *OfflineJobRequest) (<-chan *OfflineJobResponse, <-chan error) {
	responseChan := make(chan *OfflineJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OfflineJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OfflineJobWithCallback invokes the foas.OfflineJob API asynchronously
// api document: https://help.aliyun.com/api/foas/offlinejob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OfflineJobWithCallback(request *OfflineJobRequest, callback func(response *OfflineJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OfflineJobResponse
		var err error
		defer close(result)
		response, err = client.OfflineJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OfflineJobRequest is the request struct for api OfflineJob
type OfflineJobRequest struct {
	*requests.RoaRequest
	ProjectName string `position:"Path" name:"projectName"`
	JobName     string `position:"Path" name:"jobName"`
}

// OfflineJobResponse is the response struct for api OfflineJob
type OfflineJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateOfflineJobRequest creates a request to invoke OfflineJob API
func CreateOfflineJobRequest() (request *OfflineJobRequest) {
	request = &OfflineJobRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("foas", "2018-11-11", "OfflineJob", "/api/v2/projects/[projectName]/jobs/[jobName]/offline", "foas", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateOfflineJobResponse creates a response to parse from OfflineJob response
func CreateOfflineJobResponse() (response *OfflineJobResponse) {
	response = &OfflineJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
