package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateAuditCallback invokes the green.CreateAuditCallback API synchronously
func (client *Client) CreateAuditCallback(request *CreateAuditCallbackRequest) (response *CreateAuditCallbackResponse, err error) {
	response = CreateCreateAuditCallbackResponse()
	err = client.DoAction(request, response)
	return
}

// CreateAuditCallbackWithChan invokes the green.CreateAuditCallback API asynchronously
func (client *Client) CreateAuditCallbackWithChan(request *CreateAuditCallbackRequest) (<-chan *CreateAuditCallbackResponse, <-chan error) {
	responseChan := make(chan *CreateAuditCallbackResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateAuditCallback(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateAuditCallbackWithCallback invokes the green.CreateAuditCallback API asynchronously
func (client *Client) CreateAuditCallbackWithCallback(request *CreateAuditCallbackRequest, callback func(response *CreateAuditCallbackResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateAuditCallbackResponse
		var err error
		defer close(result)
		response, err = client.CreateAuditCallback(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateAuditCallbackRequest is the request struct for api CreateAuditCallback
type CreateAuditCallbackRequest struct {
	*requests.RpcRequest
	CallbackTypes       string `position:"Query" name:"CallbackTypes"`
	CallbackSuggestions string `position:"Query" name:"CallbackSuggestions"`
	Url                 string `position:"Query" name:"Url"`
	CryptType           string `position:"Query" name:"CryptType"`
	SourceIp            string `position:"Query" name:"SourceIp"`
	Name                string `position:"Query" name:"Name"`
}

// CreateAuditCallbackResponse is the response struct for api CreateAuditCallback
type CreateAuditCallbackResponse struct {
	*responses.BaseResponse
	RequestId           string   `json:"RequestId" xml:"RequestId"`
	Id                  int64    `json:"Id" xml:"Id"`
	Name                string   `json:"Name" xml:"Name"`
	Url                 string   `json:"Url" xml:"Url"`
	Seed                string   `json:"Seed" xml:"Seed"`
	CryptType           string   `json:"CryptType" xml:"CryptType"`
	CreateTime          string   `json:"CreateTime" xml:"CreateTime"`
	ModifiedTime        string   `json:"ModifiedTime" xml:"ModifiedTime"`
	CallbackTypes       []string `json:"CallbackTypes" xml:"CallbackTypes"`
	CallbackSuggestions []string `json:"CallbackSuggestions" xml:"CallbackSuggestions"`
}

// CreateCreateAuditCallbackRequest creates a request to invoke CreateAuditCallback API
func CreateCreateAuditCallbackRequest() (request *CreateAuditCallbackRequest) {
	request = &CreateAuditCallbackRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "CreateAuditCallback", "green", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateAuditCallbackResponse creates a response to parse from CreateAuditCallback response
func CreateCreateAuditCallbackResponse() (response *CreateAuditCallbackResponse) {
	response = &CreateAuditCallbackResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
