package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeWebsiteInstanceId invokes the green.DescribeWebsiteInstanceId API synchronously
func (client *Client) DescribeWebsiteInstanceId(request *DescribeWebsiteInstanceIdRequest) (response *DescribeWebsiteInstanceIdResponse, err error) {
	response = CreateDescribeWebsiteInstanceIdResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeWebsiteInstanceIdWithChan invokes the green.DescribeWebsiteInstanceId API asynchronously
func (client *Client) DescribeWebsiteInstanceIdWithChan(request *DescribeWebsiteInstanceIdRequest) (<-chan *DescribeWebsiteInstanceIdResponse, <-chan error) {
	responseChan := make(chan *DescribeWebsiteInstanceIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeWebsiteInstanceId(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeWebsiteInstanceIdWithCallback invokes the green.DescribeWebsiteInstanceId API asynchronously
func (client *Client) DescribeWebsiteInstanceIdWithCallback(request *DescribeWebsiteInstanceIdRequest, callback func(response *DescribeWebsiteInstanceIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeWebsiteInstanceIdResponse
		var err error
		defer close(result)
		response, err = client.DescribeWebsiteInstanceId(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeWebsiteInstanceIdRequest is the request struct for api DescribeWebsiteInstanceId
type DescribeWebsiteInstanceIdRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	Lang     string `position:"Query" name:"Lang"`
}

// DescribeWebsiteInstanceIdResponse is the response struct for api DescribeWebsiteInstanceId
type DescribeWebsiteInstanceIdResponse struct {
	*responses.BaseResponse
	RequestId             string   `json:"RequestId" xml:"RequestId"`
	TotalCount            int      `json:"TotalCount" xml:"TotalCount"`
	WebsiteInstanceIdList []string `json:"WebsiteInstanceIdList" xml:"WebsiteInstanceIdList"`
}

// CreateDescribeWebsiteInstanceIdRequest creates a request to invoke DescribeWebsiteInstanceId API
func CreateDescribeWebsiteInstanceIdRequest() (request *DescribeWebsiteInstanceIdRequest) {
	request = &DescribeWebsiteInstanceIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "DescribeWebsiteInstanceId", "green", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeWebsiteInstanceIdResponse creates a response to parse from DescribeWebsiteInstanceId response
func CreateDescribeWebsiteInstanceIdResponse() (response *DescribeWebsiteInstanceIdResponse) {
	response = &DescribeWebsiteInstanceIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
