package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// VodAsyncScan invokes the green.VodAsyncScan API synchronously
func (client *Client) VodAsyncScan(request *VodAsyncScanRequest) (response *VodAsyncScanResponse, err error) {
	response = CreateVodAsyncScanResponse()
	err = client.DoAction(request, response)
	return
}

// VodAsyncScanWithChan invokes the green.VodAsyncScan API asynchronously
func (client *Client) VodAsyncScanWithChan(request *VodAsyncScanRequest) (<-chan *VodAsyncScanResponse, <-chan error) {
	responseChan := make(chan *VodAsyncScanResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.VodAsyncScan(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// VodAsyncScanWithCallback invokes the green.VodAsyncScan API asynchronously
func (client *Client) VodAsyncScanWithCallback(request *VodAsyncScanRequest, callback func(response *VodAsyncScanResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *VodAsyncScanResponse
		var err error
		defer close(result)
		response, err = client.VodAsyncScan(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// VodAsyncScanRequest is the request struct for api VodAsyncScan
type VodAsyncScanRequest struct {
	*requests.RoaRequest
	ClientInfo string `position:"Query" name:"ClientInfo"`
}

// VodAsyncScanResponse is the response struct for api VodAsyncScan
type VodAsyncScanResponse struct {
	*responses.BaseResponse
}

// CreateVodAsyncScanRequest creates a request to invoke VodAsyncScan API
func CreateVodAsyncScanRequest() (request *VodAsyncScanRequest) {
	request = &VodAsyncScanRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Green", "2018-05-09", "VodAsyncScan", "/green/vod/asyncscan", "green", "openAPI")
	request.Method = requests.POST
	return
}

// CreateVodAsyncScanResponse creates a response to parse from VodAsyncScan response
func CreateVodAsyncScanResponse() (response *VodAsyncScanResponse) {
	response = &VodAsyncScanResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
