package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// VoiceAsyncScanResults invokes the green.VoiceAsyncScanResults API synchronously
func (client *Client) VoiceAsyncScanResults(request *VoiceAsyncScanResultsRequest) (response *VoiceAsyncScanResultsResponse, err error) {
	response = CreateVoiceAsyncScanResultsResponse()
	err = client.DoAction(request, response)
	return
}

// VoiceAsyncScanResultsWithChan invokes the green.VoiceAsyncScanResults API asynchronously
func (client *Client) VoiceAsyncScanResultsWithChan(request *VoiceAsyncScanResultsRequest) (<-chan *VoiceAsyncScanResultsResponse, <-chan error) {
	responseChan := make(chan *VoiceAsyncScanResultsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.VoiceAsyncScanResults(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// VoiceAsyncScanResultsWithCallback invokes the green.VoiceAsyncScanResults API asynchronously
func (client *Client) VoiceAsyncScanResultsWithCallback(request *VoiceAsyncScanResultsRequest, callback func(response *VoiceAsyncScanResultsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *VoiceAsyncScanResultsResponse
		var err error
		defer close(result)
		response, err = client.VoiceAsyncScanResults(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// VoiceAsyncScanResultsRequest is the request struct for api VoiceAsyncScanResults
type VoiceAsyncScanResultsRequest struct {
	*requests.RoaRequest
	ClientInfo string `position:"Query" name:"ClientInfo"`
}

// VoiceAsyncScanResultsResponse is the response struct for api VoiceAsyncScanResults
type VoiceAsyncScanResultsResponse struct {
	*responses.BaseResponse
}

// CreateVoiceAsyncScanResultsRequest creates a request to invoke VoiceAsyncScanResults API
func CreateVoiceAsyncScanResultsRequest() (request *VoiceAsyncScanResultsRequest) {
	request = &VoiceAsyncScanResultsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Green", "2018-05-09", "VoiceAsyncScanResults", "/green/voice/results", "green", "openAPI")
	request.Method = requests.POST
	return
}

// CreateVoiceAsyncScanResultsResponse creates a response to parse from VoiceAsyncScanResults response
func CreateVoiceAsyncScanResultsResponse() (response *VoiceAsyncScanResultsResponse) {
	response = &VoiceAsyncScanResultsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
