package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// WebpageSyncScan invokes the green.WebpageSyncScan API synchronously
func (client *Client) WebpageSyncScan(request *WebpageSyncScanRequest) (response *WebpageSyncScanResponse, err error) {
	response = CreateWebpageSyncScanResponse()
	err = client.DoAction(request, response)
	return
}

// WebpageSyncScanWithChan invokes the green.WebpageSyncScan API asynchronously
func (client *Client) WebpageSyncScanWithChan(request *WebpageSyncScanRequest) (<-chan *WebpageSyncScanResponse, <-chan error) {
	responseChan := make(chan *WebpageSyncScanResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.WebpageSyncScan(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// WebpageSyncScanWithCallback invokes the green.WebpageSyncScan API asynchronously
func (client *Client) WebpageSyncScanWithCallback(request *WebpageSyncScanRequest, callback func(response *WebpageSyncScanResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *WebpageSyncScanResponse
		var err error
		defer close(result)
		response, err = client.WebpageSyncScan(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// WebpageSyncScanRequest is the request struct for api WebpageSyncScan
type WebpageSyncScanRequest struct {
	*requests.RoaRequest
	ClientInfo string `position:"Query" name:"ClientInfo"`
}

// WebpageSyncScanResponse is the response struct for api WebpageSyncScan
type WebpageSyncScanResponse struct {
	*responses.BaseResponse
}

// CreateWebpageSyncScanRequest creates a request to invoke WebpageSyncScan API
func CreateWebpageSyncScanRequest() (request *WebpageSyncScanRequest) {
	request = &WebpageSyncScanRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Green", "2018-05-09", "WebpageSyncScan", "/green/webpage/scan", "green", "openAPI")
	request.Method = requests.POST
	return
}

// CreateWebpageSyncScanResponse creates a response to parse from WebpageSyncScan response
func CreateWebpageSyncScanResponse() (response *WebpageSyncScanResponse) {
	response = &WebpageSyncScanResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
