package imageenhan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RecolorHDImage invokes the imageenhan.RecolorHDImage API synchronously
func (client *Client) RecolorHDImage(request *RecolorHDImageRequest) (response *RecolorHDImageResponse, err error) {
	response = CreateRecolorHDImageResponse()
	err = client.DoAction(request, response)
	return
}

// RecolorHDImageWithChan invokes the imageenhan.RecolorHDImage API asynchronously
func (client *Client) RecolorHDImageWithChan(request *RecolorHDImageRequest) (<-chan *RecolorHDImageResponse, <-chan error) {
	responseChan := make(chan *RecolorHDImageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RecolorHDImage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecolorHDImageWithCallback invokes the imageenhan.RecolorHDImage API asynchronously
func (client *Client) RecolorHDImageWithCallback(request *RecolorHDImageRequest, callback func(response *RecolorHDImageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecolorHDImageResponse
		var err error
		defer close(result)
		response, err = client.RecolorHDImage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecolorHDImageRequest is the request struct for api RecolorHDImage
type RecolorHDImageRequest struct {
	*requests.RpcRequest
	ColorTemplate *[]RecolorHDImageColorTemplate `position:"Body" name:"ColorTemplate"  type:"Repeated"`
	Degree        string                         `position:"Body" name:"Degree"`
	Url           string                         `position:"Body" name:"Url"`
	Mode          string                         `position:"Body" name:"Mode"`
	Async         requests.Boolean               `position:"Body" name:"Async"`
	ColorCount    requests.Integer               `position:"Body" name:"ColorCount"`
	RefUrl        string                         `position:"Body" name:"RefUrl"`
}

// RecolorHDImageColorTemplate is a repeated param struct in RecolorHDImageRequest
type RecolorHDImageColorTemplate struct {
	Color string `name:"Color"`
}

// RecolorHDImageResponse is the response struct for api RecolorHDImage
type RecolorHDImageResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateRecolorHDImageRequest creates a request to invoke RecolorHDImage API
func CreateRecolorHDImageRequest() (request *RecolorHDImageRequest) {
	request = &RecolorHDImageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageenhan", "2019-09-30", "RecolorHDImage", "imageenhan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRecolorHDImageResponse creates a response to parse from RecolorHDImage response
func CreateRecolorHDImageResponse() (response *RecolorHDImageResponse) {
	response = &RecolorHDImageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
