package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryDevicePropertyStatus invokes the iot.QueryDevicePropertyStatus API synchronously
func (client *Client) QueryDevicePropertyStatus(request *QueryDevicePropertyStatusRequest) (response *QueryDevicePropertyStatusResponse, err error) {
	response = CreateQueryDevicePropertyStatusResponse()
	err = client.DoAction(request, response)
	return
}

// QueryDevicePropertyStatusWithChan invokes the iot.QueryDevicePropertyStatus API asynchronously
func (client *Client) QueryDevicePropertyStatusWithChan(request *QueryDevicePropertyStatusRequest) (<-chan *QueryDevicePropertyStatusResponse, <-chan error) {
	responseChan := make(chan *QueryDevicePropertyStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryDevicePropertyStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryDevicePropertyStatusWithCallback invokes the iot.QueryDevicePropertyStatus API asynchronously
func (client *Client) QueryDevicePropertyStatusWithCallback(request *QueryDevicePropertyStatusRequest, callback func(response *QueryDevicePropertyStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryDevicePropertyStatusResponse
		var err error
		defer close(result)
		response, err = client.QueryDevicePropertyStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryDevicePropertyStatusRequest is the request struct for api QueryDevicePropertyStatus
type QueryDevicePropertyStatusRequest struct {
	*requests.RpcRequest
	RealTenantId      string `position:"Query" name:"RealTenantId"`
	RealTripartiteKey string `position:"Query" name:"RealTripartiteKey"`
	IotId             string `position:"Query" name:"IotId"`
	IotInstanceId     string `position:"Query" name:"IotInstanceId"`
	ProductKey        string `position:"Query" name:"ProductKey"`
	ApiProduct        string `position:"Body" name:"ApiProduct"`
	ApiRevision       string `position:"Body" name:"ApiRevision"`
	DeviceName        string `position:"Query" name:"DeviceName"`
	FunctionBlockId   string `position:"Query" name:"FunctionBlockId"`
}

// QueryDevicePropertyStatusResponse is the response struct for api QueryDevicePropertyStatus
type QueryDevicePropertyStatusResponse struct {
	*responses.BaseResponse
	RequestId    string                          `json:"RequestId" xml:"RequestId"`
	Success      bool                            `json:"Success" xml:"Success"`
	Code         string                          `json:"Code" xml:"Code"`
	ErrorMessage string                          `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         DataInQueryDevicePropertyStatus `json:"Data" xml:"Data"`
}

// CreateQueryDevicePropertyStatusRequest creates a request to invoke QueryDevicePropertyStatus API
func CreateQueryDevicePropertyStatusRequest() (request *QueryDevicePropertyStatusRequest) {
	request = &QueryDevicePropertyStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "QueryDevicePropertyStatus", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryDevicePropertyStatusResponse creates a response to parse from QueryDevicePropertyStatus response
func CreateQueryDevicePropertyStatusResponse() (response *QueryDevicePropertyStatusResponse) {
	response = &QueryDevicePropertyStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
