package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySpeechList invokes the iot.QuerySpeechList API synchronously
func (client *Client) QuerySpeechList(request *QuerySpeechListRequest) (response *QuerySpeechListResponse, err error) {
	response = CreateQuerySpeechListResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySpeechListWithChan invokes the iot.QuerySpeechList API asynchronously
func (client *Client) QuerySpeechListWithChan(request *QuerySpeechListRequest) (<-chan *QuerySpeechListResponse, <-chan error) {
	responseChan := make(chan *QuerySpeechListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySpeechList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySpeechListWithCallback invokes the iot.QuerySpeechList API asynchronously
func (client *Client) QuerySpeechListWithCallback(request *QuerySpeechListRequest, callback func(response *QuerySpeechListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySpeechListResponse
		var err error
		defer close(result)
		response, err = client.QuerySpeechList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySpeechListRequest is the request struct for api QuerySpeechList
type QuerySpeechListRequest struct {
	*requests.RpcRequest
	ProjectCode   string           `position:"Body" name:"ProjectCode"`
	PageId        requests.Integer `position:"Body" name:"PageId"`
	AudioFormat   string           `position:"Body" name:"AudioFormat"`
	IotInstanceId string           `position:"Body" name:"IotInstanceId"`
	PageSize      requests.Integer `position:"Body" name:"PageSize"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
}

// QuerySpeechListResponse is the response struct for api QuerySpeechList
type QuerySpeechListResponse struct {
	*responses.BaseResponse
	RequestId    string                `json:"RequestId" xml:"RequestId"`
	Success      bool                  `json:"Success" xml:"Success"`
	Code         string                `json:"Code" xml:"Code"`
	ErrorMessage string                `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         DataInQuerySpeechList `json:"Data" xml:"Data"`
}

// CreateQuerySpeechListRequest creates a request to invoke QuerySpeechList API
func CreateQuerySpeechListRequest() (request *QuerySpeechListRequest) {
	request = &QuerySpeechListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "QuerySpeechList", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQuerySpeechListResponse creates a response to parse from QuerySpeechList response
func CreateQuerySpeechListResponse() (response *QuerySpeechListResponse) {
	response = &QuerySpeechListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
