package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateThingModelValidationConfig invokes the iot.UpdateThingModelValidationConfig API synchronously
func (client *Client) UpdateThingModelValidationConfig(request *UpdateThingModelValidationConfigRequest) (response *UpdateThingModelValidationConfigResponse, err error) {
	response = CreateUpdateThingModelValidationConfigResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateThingModelValidationConfigWithChan invokes the iot.UpdateThingModelValidationConfig API asynchronously
func (client *Client) UpdateThingModelValidationConfigWithChan(request *UpdateThingModelValidationConfigRequest) (<-chan *UpdateThingModelValidationConfigResponse, <-chan error) {
	responseChan := make(chan *UpdateThingModelValidationConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateThingModelValidationConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateThingModelValidationConfigWithCallback invokes the iot.UpdateThingModelValidationConfig API asynchronously
func (client *Client) UpdateThingModelValidationConfigWithCallback(request *UpdateThingModelValidationConfigRequest, callback func(response *UpdateThingModelValidationConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateThingModelValidationConfigResponse
		var err error
		defer close(result)
		response, err = client.UpdateThingModelValidationConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateThingModelValidationConfigRequest is the request struct for api UpdateThingModelValidationConfig
type UpdateThingModelValidationConfigRequest struct {
	*requests.RpcRequest
	ValidateType  requests.Integer `position:"Query" name:"ValidateType"`
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	ProductKey    string           `position:"Query" name:"ProductKey"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
}

// UpdateThingModelValidationConfigResponse is the response struct for api UpdateThingModelValidationConfig
type UpdateThingModelValidationConfigResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateUpdateThingModelValidationConfigRequest creates a request to invoke UpdateThingModelValidationConfig API
func CreateUpdateThingModelValidationConfigRequest() (request *UpdateThingModelValidationConfigRequest) {
	request = &UpdateThingModelValidationConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "UpdateThingModelValidationConfig", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateThingModelValidationConfigResponse creates a response to parse from UpdateThingModelValidationConfig response
func CreateUpdateThingModelValidationConfigResponse() (response *UpdateThingModelValidationConfigResponse) {
	response = &UpdateThingModelValidationConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
