package nas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OpenNASService invokes the nas.OpenNASService API synchronously
func (client *Client) OpenNASService(request *OpenNASServiceRequest) (response *OpenNASServiceResponse, err error) {
	response = CreateOpenNASServiceResponse()
	err = client.DoAction(request, response)
	return
}

// OpenNASServiceWithChan invokes the nas.OpenNASService API asynchronously
func (client *Client) OpenNASServiceWithChan(request *OpenNASServiceRequest) (<-chan *OpenNASServiceResponse, <-chan error) {
	responseChan := make(chan *OpenNASServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OpenNASService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OpenNASServiceWithCallback invokes the nas.OpenNASService API asynchronously
func (client *Client) OpenNASServiceWithCallback(request *OpenNASServiceRequest, callback func(response *OpenNASServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OpenNASServiceResponse
		var err error
		defer close(result)
		response, err = client.OpenNASService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OpenNASServiceRequest is the request struct for api OpenNASService
type OpenNASServiceRequest struct {
	*requests.RpcRequest
}

// OpenNASServiceResponse is the response struct for api OpenNASService
type OpenNASServiceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	OrderId   string `json:"OrderId" xml:"OrderId"`
}

// CreateOpenNASServiceRequest creates a request to invoke OpenNASService API
func CreateOpenNASServiceRequest() (request *OpenNASServiceRequest) {
	request = &OpenNASServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "OpenNASService", "", "")
	request.Method = requests.POST
	return
}

// CreateOpenNASServiceResponse creates a response to parse from OpenNASService response
func CreateOpenNASServiceResponse() (response *OpenNASServiceResponse) {
	response = &OpenNASServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
