package oam

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListRoleCellsByResourceAndAction invokes the oam.ListRoleCellsByResourceAndAction API synchronously
// api document: https://help.aliyun.com/api/oam/listrolecellsbyresourceandaction.html
func (client *Client) ListRoleCellsByResourceAndAction(request *ListRoleCellsByResourceAndActionRequest) (response *ListRoleCellsByResourceAndActionResponse, err error) {
	response = CreateListRoleCellsByResourceAndActionResponse()
	err = client.DoAction(request, response)
	return
}

// ListRoleCellsByResourceAndActionWithChan invokes the oam.ListRoleCellsByResourceAndAction API asynchronously
// api document: https://help.aliyun.com/api/oam/listrolecellsbyresourceandaction.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListRoleCellsByResourceAndActionWithChan(request *ListRoleCellsByResourceAndActionRequest) (<-chan *ListRoleCellsByResourceAndActionResponse, <-chan error) {
	responseChan := make(chan *ListRoleCellsByResourceAndActionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListRoleCellsByResourceAndAction(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListRoleCellsByResourceAndActionWithCallback invokes the oam.ListRoleCellsByResourceAndAction API asynchronously
// api document: https://help.aliyun.com/api/oam/listrolecellsbyresourceandaction.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListRoleCellsByResourceAndActionWithCallback(request *ListRoleCellsByResourceAndActionRequest, callback func(response *ListRoleCellsByResourceAndActionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListRoleCellsByResourceAndActionResponse
		var err error
		defer close(result)
		response, err = client.ListRoleCellsByResourceAndAction(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListRoleCellsByResourceAndActionRequest is the request struct for api ListRoleCellsByResourceAndAction
type ListRoleCellsByResourceAndActionRequest struct {
	*requests.RpcRequest
	Resource    string `position:"Query" name:"Resource"`
	ActionField string `position:"Query" name:"ActionField"`
}

// ListRoleCellsByResourceAndActionResponse is the response struct for api ListRoleCellsByResourceAndAction
type ListRoleCellsByResourceAndActionResponse struct {
	*responses.BaseResponse
	Code    string                                 `json:"Code" xml:"Code"`
	Message string                                 `json:"Message" xml:"Message"`
	Data    DataInListRoleCellsByResourceAndAction `json:"Data" xml:"Data"`
}

// CreateListRoleCellsByResourceAndActionRequest creates a request to invoke ListRoleCellsByResourceAndAction API
func CreateListRoleCellsByResourceAndActionRequest() (request *ListRoleCellsByResourceAndActionRequest) {
	request = &ListRoleCellsByResourceAndActionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Oam", "2017-01-01", "ListRoleCellsByResourceAndAction", "", "")
	request.Method = requests.POST
	return
}

// CreateListRoleCellsByResourceAndActionResponse creates a response to parse from ListRoleCellsByResourceAndAction response
func CreateListRoleCellsByResourceAndActionResponse() (response *ListRoleCellsByResourceAndActionResponse) {
	response = &ListRoleCellsByResourceAndActionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
