package ocr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RecognizeBusinessLicense invokes the ocr.RecognizeBusinessLicense API synchronously
func (client *Client) RecognizeBusinessLicense(request *RecognizeBusinessLicenseRequest) (response *RecognizeBusinessLicenseResponse, err error) {
	response = CreateRecognizeBusinessLicenseResponse()
	err = client.DoAction(request, response)
	return
}

// RecognizeBusinessLicenseWithChan invokes the ocr.RecognizeBusinessLicense API asynchronously
func (client *Client) RecognizeBusinessLicenseWithChan(request *RecognizeBusinessLicenseRequest) (<-chan *RecognizeBusinessLicenseResponse, <-chan error) {
	responseChan := make(chan *RecognizeBusinessLicenseResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RecognizeBusinessLicense(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecognizeBusinessLicenseWithCallback invokes the ocr.RecognizeBusinessLicense API asynchronously
func (client *Client) RecognizeBusinessLicenseWithCallback(request *RecognizeBusinessLicenseRequest, callback func(response *RecognizeBusinessLicenseResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecognizeBusinessLicenseResponse
		var err error
		defer close(result)
		response, err = client.RecognizeBusinessLicense(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecognizeBusinessLicenseRequest is the request struct for api RecognizeBusinessLicense
type RecognizeBusinessLicenseRequest struct {
	*requests.RpcRequest
	ImageType requests.Integer `position:"Body" name:"ImageType"`
	ImageURL  string           `position:"Body" name:"ImageURL"`
}

// RecognizeBusinessLicenseResponse is the response struct for api RecognizeBusinessLicense
type RecognizeBusinessLicenseResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateRecognizeBusinessLicenseRequest creates a request to invoke RecognizeBusinessLicense API
func CreateRecognizeBusinessLicenseRequest() (request *RecognizeBusinessLicenseRequest) {
	request = &RecognizeBusinessLicenseRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ocr", "2019-12-30", "RecognizeBusinessLicense", "ocr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRecognizeBusinessLicenseResponse creates a response to parse from RecognizeBusinessLicense response
func CreateRecognizeBusinessLicenseResponse() (response *RecognizeBusinessLicenseResponse) {
	response = &RecognizeBusinessLicenseResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
