package polardbx

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreatePolarxOrder invokes the polardbx.CreatePolarxOrder API synchronously
func (client *Client) CreatePolarxOrder(request *CreatePolarxOrderRequest) (response *CreatePolarxOrderResponse, err error) {
	response = CreateCreatePolarxOrderResponse()
	err = client.DoAction(request, response)
	return
}

// CreatePolarxOrderWithChan invokes the polardbx.CreatePolarxOrder API asynchronously
func (client *Client) CreatePolarxOrderWithChan(request *CreatePolarxOrderRequest) (<-chan *CreatePolarxOrderResponse, <-chan error) {
	responseChan := make(chan *CreatePolarxOrderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreatePolarxOrder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreatePolarxOrderWithCallback invokes the polardbx.CreatePolarxOrder API asynchronously
func (client *Client) CreatePolarxOrderWithCallback(request *CreatePolarxOrderRequest, callback func(response *CreatePolarxOrderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreatePolarxOrderResponse
		var err error
		defer close(result)
		response, err = client.CreatePolarxOrder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreatePolarxOrderRequest is the request struct for api CreatePolarxOrder
type CreatePolarxOrderRequest struct {
	*requests.RpcRequest
	DBInstanceName string `position:"Query" name:"DBInstanceName"`
	NodeCount      string `position:"Query" name:"NodeCount"`
}

// CreatePolarxOrderResponse is the response struct for api CreatePolarxOrder
type CreatePolarxOrderResponse struct {
	*responses.BaseResponse
	RequestId       string        `json:"RequestId" xml:"RequestId"`
	OrderResultList []OrderResult `json:"OrderResultList" xml:"OrderResultList"`
}

// CreateCreatePolarxOrderRequest creates a request to invoke CreatePolarxOrder API
func CreateCreatePolarxOrderRequest() (request *CreatePolarxOrderRequest) {
	request = &CreatePolarxOrderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardbx", "2020-02-02", "CreatePolarxOrder", "polardbx", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreatePolarxOrderResponse creates a response to parse from CreatePolarxOrder response
func CreateCreatePolarxOrderResponse() (response *CreatePolarxOrderResponse) {
	response = &CreatePolarxOrderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
