package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteBusinessCategory invokes the qualitycheck.DeleteBusinessCategory API synchronously
func (client *Client) DeleteBusinessCategory(request *DeleteBusinessCategoryRequest) (response *DeleteBusinessCategoryResponse, err error) {
	response = CreateDeleteBusinessCategoryResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteBusinessCategoryWithChan invokes the qualitycheck.DeleteBusinessCategory API asynchronously
func (client *Client) DeleteBusinessCategoryWithChan(request *DeleteBusinessCategoryRequest) (<-chan *DeleteBusinessCategoryResponse, <-chan error) {
	responseChan := make(chan *DeleteBusinessCategoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteBusinessCategory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteBusinessCategoryWithCallback invokes the qualitycheck.DeleteBusinessCategory API asynchronously
func (client *Client) DeleteBusinessCategoryWithCallback(request *DeleteBusinessCategoryRequest, callback func(response *DeleteBusinessCategoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteBusinessCategoryResponse
		var err error
		defer close(result)
		response, err = client.DeleteBusinessCategory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteBusinessCategoryRequest is the request struct for api DeleteBusinessCategory
type DeleteBusinessCategoryRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
}

// DeleteBusinessCategoryResponse is the response struct for api DeleteBusinessCategory
type DeleteBusinessCategoryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateDeleteBusinessCategoryRequest creates a request to invoke DeleteBusinessCategory API
func CreateDeleteBusinessCategoryRequest() (request *DeleteBusinessCategoryRequest) {
	request = &DeleteBusinessCategoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "DeleteBusinessCategory", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteBusinessCategoryResponse creates a response to parse from DeleteBusinessCategory response
func CreateDeleteBusinessCategoryResponse() (response *DeleteBusinessCategoryResponse) {
	response = &DeleteBusinessCategoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
