package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAsrVocab invokes the qualitycheck.ListAsrVocab API synchronously
func (client *Client) ListAsrVocab(request *ListAsrVocabRequest) (response *ListAsrVocabResponse, err error) {
	response = CreateListAsrVocabResponse()
	err = client.DoAction(request, response)
	return
}

// ListAsrVocabWithChan invokes the qualitycheck.ListAsrVocab API asynchronously
func (client *Client) ListAsrVocabWithChan(request *ListAsrVocabRequest) (<-chan *ListAsrVocabResponse, <-chan error) {
	responseChan := make(chan *ListAsrVocabResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAsrVocab(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAsrVocabWithCallback invokes the qualitycheck.ListAsrVocab API asynchronously
func (client *Client) ListAsrVocabWithCallback(request *ListAsrVocabRequest, callback func(response *ListAsrVocabResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAsrVocabResponse
		var err error
		defer close(result)
		response, err = client.ListAsrVocab(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAsrVocabRequest is the request struct for api ListAsrVocab
type ListAsrVocabRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
}

// ListAsrVocabResponse is the response struct for api ListAsrVocab
type ListAsrVocabResponse struct {
	*responses.BaseResponse
	RequestId string             `json:"RequestId" xml:"RequestId"`
	Success   bool               `json:"Success" xml:"Success"`
	Code      string             `json:"Code" xml:"Code"`
	Message   string             `json:"Message" xml:"Message"`
	Data      DataInListAsrVocab `json:"Data" xml:"Data"`
}

// CreateListAsrVocabRequest creates a request to invoke ListAsrVocab API
func CreateListAsrVocabRequest() (request *ListAsrVocabRequest) {
	request = &ListAsrVocabRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "ListAsrVocab", "", "")
	request.Method = requests.POST
	return
}

// CreateListAsrVocabResponse creates a response to parse from ListAsrVocab response
func CreateListAsrVocabResponse() (response *ListAsrVocabResponse) {
	response = &ListAsrVocabResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
