package retailcloud

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPods invokes the retailcloud.ListPods API synchronously
func (client *Client) ListPods(request *ListPodsRequest) (response *ListPodsResponse, err error) {
	response = CreateListPodsResponse()
	err = client.DoAction(request, response)
	return
}

// ListPodsWithChan invokes the retailcloud.ListPods API asynchronously
func (client *Client) ListPodsWithChan(request *ListPodsRequest) (<-chan *ListPodsResponse, <-chan error) {
	responseChan := make(chan *ListPodsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPods(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPodsWithCallback invokes the retailcloud.ListPods API asynchronously
func (client *Client) ListPodsWithCallback(request *ListPodsRequest, callback func(response *ListPodsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPodsResponse
		var err error
		defer close(result)
		response, err = client.ListPods(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPodsRequest is the request struct for api ListPods
type ListPodsRequest struct {
	*requests.RpcRequest
	StatusList    *[]string        `position:"Body" name:"StatusList"  type:"Repeated"`
	DeployOrderId requests.Integer `position:"Query" name:"DeployOrderId"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	PageNumber    requests.Integer `position:"Query" name:"PageNumber"`
	ResultList    *[]string        `position:"Body" name:"ResultList"  type:"Repeated"`
}

// ListPodsResponse is the response struct for api ListPods
type ListPodsResponse struct {
	*responses.BaseResponse
	Code       int         `json:"Code" xml:"Code"`
	ErrorMsg   string      `json:"ErrorMsg" xml:"ErrorMsg"`
	PageNumber int         `json:"PageNumber" xml:"PageNumber"`
	PageSize   int         `json:"PageSize" xml:"PageSize"`
	RequestId  string      `json:"RequestId" xml:"RequestId"`
	TotalCount int64       `json:"TotalCount" xml:"TotalCount"`
	Data       []PodDetail `json:"Data" xml:"Data"`
}

// CreateListPodsRequest creates a request to invoke ListPods API
func CreateListPodsRequest() (request *ListPodsRequest) {
	request = &ListPodsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailcloud", "2018-03-13", "ListPods", "", "")
	request.Method = requests.POST
	return
}

// CreateListPodsResponse creates a response to parse from ListPods response
func CreateListPodsResponse() (response *ListPodsResponse) {
	response = &ListPodsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
