package rtc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRtcChannelDetail invokes the rtc.DescribeRtcChannelDetail API synchronously
func (client *Client) DescribeRtcChannelDetail(request *DescribeRtcChannelDetailRequest) (response *DescribeRtcChannelDetailResponse, err error) {
	response = CreateDescribeRtcChannelDetailResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRtcChannelDetailWithChan invokes the rtc.DescribeRtcChannelDetail API asynchronously
func (client *Client) DescribeRtcChannelDetailWithChan(request *DescribeRtcChannelDetailRequest) (<-chan *DescribeRtcChannelDetailResponse, <-chan error) {
	responseChan := make(chan *DescribeRtcChannelDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRtcChannelDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRtcChannelDetailWithCallback invokes the rtc.DescribeRtcChannelDetail API asynchronously
func (client *Client) DescribeRtcChannelDetailWithCallback(request *DescribeRtcChannelDetailRequest, callback func(response *DescribeRtcChannelDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRtcChannelDetailResponse
		var err error
		defer close(result)
		response, err = client.DescribeRtcChannelDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRtcChannelDetailRequest is the request struct for api DescribeRtcChannelDetail
type DescribeRtcChannelDetailRequest struct {
	*requests.RpcRequest
	StartTime string           `position:"Query" name:"StartTime"`
	PageSize  requests.Integer `position:"Query" name:"PageSize"`
	ShowLog   string           `position:"Query" name:"ShowLog"`
	EndTime   string           `position:"Query" name:"EndTime"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
	PageNo    requests.Integer `position:"Query" name:"PageNo"`
	AppId     string           `position:"Query" name:"AppId"`
	ChannelId string           `position:"Query" name:"ChannelId"`
}

// DescribeRtcChannelDetailResponse is the response struct for api DescribeRtcChannelDetail
type DescribeRtcChannelDetailResponse struct {
	*responses.BaseResponse
	RequestId   string   `json:"RequestId" xml:"RequestId"`
	ChannelId   string   `json:"ChannelId" xml:"ChannelId"`
	PageSize    int64    `json:"PageSize" xml:"PageSize"`
	PageNo      int64    `json:"PageNo" xml:"PageNo"`
	TotalCnt    int64    `json:"TotalCnt" xml:"TotalCnt"`
	ChannelInfo []Detail `json:"ChannelInfo" xml:"ChannelInfo"`
}

// CreateDescribeRtcChannelDetailRequest creates a request to invoke DescribeRtcChannelDetail API
func CreateDescribeRtcChannelDetailRequest() (request *DescribeRtcChannelDetailRequest) {
	request = &DescribeRtcChannelDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "DescribeRtcChannelDetail", "rtc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeRtcChannelDetailResponse creates a response to parse from DescribeRtcChannelDetail response
func CreateDescribeRtcChannelDetailResponse() (response *DescribeRtcChannelDetailResponse) {
	response = &DescribeRtcChannelDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
